/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.dto.IMatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum SearchableEntity {
    EXPERIMENT("Experiment", EntityKind.EXPERIMENT),
    SAMPLE("Sample", EntityKind.SAMPLE),
    DATA_SET("Data Set", EntityKind.DATA_SET),
    MATERIAL("Material", EntityKind.MATERIAL);

    private final String description;
    private final EntityKind entityKind;

    private SearchableEntity(String description, EntityKind entityKind) {
        this.description = description;
        this.entityKind = entityKind;
    }

    public EntityKind getEntityKind() {
        return this.entityKind;
    }

    public final String getDescription() {
        return this.description;
    }

    public final String getName() {
        return this.name();
    }

    public <T extends IMatchingEntity> Class<T> getMatchingEntityClass() {
        return SearchableEntity.cast(this.entityKind.getEntityClass());
    }

    static final <T> Class<T> cast(Class<?> clazz) {
        return clazz;
    }

    public final String toString() {
        return this.getDescription();
    }
}

