/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.utilities.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Store;
import org.hibernate.validator.Length;
import org.hibernate.validator.NotNull;
import org.hibernate.validator.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="spaces", uniqueConstraints={@UniqueConstraint(columnNames={"code", "dbin_id"})})
public final class SpacePE
extends HibernateAbstractRegistrationHolder
implements IIdAndCodeHolder,
Comparable<SpacePE>,
Serializable {
    private static final long serialVersionUID = 32L;
    public static final SpacePE[] EMPTY_ARRAY = new SpacePE[0];
    private transient Long id;
    private String code;
    private String description;
    private DatabaseInstancePE databaseInstance;
    private Boolean home;
    private List<ProjectPE> projects = new ArrayList<ProjectPE>();

    public final void setCode(String code) {
        this.code = code;
    }

    @Column(name="description")
    @Length(max=2000, message="Given description '%s' is too long (maximal length: {max} characters).")
    public final String getDescription() {
        return this.description;
    }

    public final void setDescription(String description) {
        this.description = description;
    }

    public final void setId(Long id) {
        this.id = id;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Database instance can not be null.")
    @JoinColumn(name="dbin_id", updatable=false)
    public final DatabaseInstancePE getDatabaseInstance() {
        return this.databaseInstance;
    }

    public final void setDatabaseInstance(DatabaseInstancePE databaseInstance) {
        this.databaseInstance = databaseInstance;
    }

    @Transient
    public final Boolean isHome() {
        return this.home;
    }

    public final void setHome(Boolean home) {
        this.home = home;
    }

    @Override
    @SequenceGenerator(name="SPACE_ID_SEQ", sequenceName="SPACE_ID_SEQ", allocationSize=1)
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="SPACE_ID_SEQ")
    @Field(index=Index.NO, store=Store.YES)
    public final Long getId() {
        return this.id;
    }

    @Override
    @NotNull(message="Code can not be null.")
    @Length(min=1, max=60, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regex="^[A-Z0-9_\\-\\.]+$", flags=2, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    @Field(index=Index.TOKENIZED, store=Store.YES, name="code")
    public final String getCode() {
        return this.code;
    }

    public final boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SpacePE)) {
            return false;
        }
        SpacePE that = (SpacePE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getCode(), (Object)that.getCode());
        builder.append((Object)this.getDatabaseInstance(), (Object)that.getDatabaseInstance());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        builder.append((Object)this.getDatabaseInstance());
        return builder.toHashCode();
    }

    public final String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("code", (Object)this.getCode());
        builder.append("description", (Object)this.getDescription());
        builder.append("home", (Object)this.isHome());
        return builder.toString();
    }

    @Override
    public final int compareTo(SpacePE o) {
        return AbstractIdAndCodeHolder.compare(this, o);
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="space")
    @Private
    public List<ProjectPE> getProjects() {
        return this.projects;
    }

    private void setProjects(List<ProjectPE> projects) {
        this.projects = projects;
    }
}

