/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.identifier;

import ch.systemsx.cisd.common.utilities.StringUtilities;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class DatabaseInstanceIdentifier
implements Serializable {
    private static final long serialVersionUID = 32L;
    private String databaseInstanceCode;
    public static final String HOME = null;
    public static DatabaseInstanceIdentifier HOME_INSTANCE = new DatabaseInstanceIdentifier(HOME);

    public static DatabaseInstanceIdentifier createHome() {
        return HOME_INSTANCE;
    }

    public DatabaseInstanceIdentifier(String databaseInstanceCode) {
        this.databaseInstanceCode = databaseInstanceCode;
    }

    public DatabaseInstanceIdentifier(boolean isOriginalSource, String databaseInstanceCode) {
        this.databaseInstanceCode = isOriginalSource ? HOME : databaseInstanceCode;
    }

    public final String getDatabaseInstanceCode() {
        return StringUtils.upperCase((String)this.databaseInstanceCode);
    }

    public final void setDatabaseInstanceCode(String databaseInstanceCode) {
        this.databaseInstanceCode = databaseInstanceCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof DatabaseInstanceIdentifier)) {
            return false;
        }
        DatabaseInstanceIdentifier that = (DatabaseInstanceIdentifier)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getDatabaseInstanceCode(), (Object)that.getDatabaseInstanceCode());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getDatabaseInstanceCode());
        return builder.toHashCode();
    }

    public String toString() {
        if (this.databaseInstanceCode == null) {
            return "";
        }
        return this.databaseInstanceCode;
    }

    public boolean isHomeDatabase() {
        return this.databaseInstanceCode == null;
    }

    @Deprecated
    public void setHomeDatabase(boolean isHomeDatabase) {
    }

    protected DatabaseInstanceIdentifier() {
    }

    public int compareTo(DatabaseInstanceIdentifier other) {
        return StringUtilities.compareNullable(this.databaseInstanceCode, other.getDatabaseInstanceCode());
    }

    public static final class Constants {
        public static final char IDENTIFIER_SEPARATOR = '/';
        public static final char DATABASE_INSTANCE_SEPARATOR = ':';
    }
}

