/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.identifier;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.AbstractIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.GroupIdentifier;

public final class GroupIdentifierFactory
extends AbstractIdentifierFactory {
    public GroupIdentifierFactory(String textToParse) throws UserFailureException {
        super(textToParse);
    }

    public final GroupIdentifier createIdentifier() throws UserFailureException {
        return GroupIdentifierFactory.parseGroupIdentifier(this.getTextToParse());
    }

    private static GroupIdentifier parseGroupIdentifier(String text) {
        AbstractIdentifierFactory.TokenLexer lexer = new AbstractIdentifierFactory.TokenLexer(text);
        GroupIdentifier groupIdentifier = GroupIdentifierFactory.parseIdentifier(lexer);
        lexer.ensureNoTokensLeft();
        return groupIdentifier;
    }

    public static GroupIdentifier parseIdentifier(AbstractIdentifierFactory.TokenLexer lexer) {
        String firstToken = lexer.peek();
        String dbCodeOrNull = GroupIdentifierFactory.tryAsDatabaseIdentifier(firstToken);
        if (dbCodeOrNull == null && firstToken.length() > 0) {
            throw GroupIdentifierFactory.createSlashMissingExcp(lexer.getOriginalText());
        }
        lexer.next();
        String groupCodeOrNull = lexer.next();
        if (groupCodeOrNull.length() == 0) {
            groupCodeOrNull = null;
        } else {
            GroupIdentifierFactory.assertValidCode(groupCodeOrNull);
        }
        return new GroupIdentifier(dbCodeOrNull, groupCodeOrNull);
    }

    public static String getSchema() {
        return "[" + GroupIdentifierFactory.getDatabaseInstanceIdentifierSchema() + ':' + "]" + '/' + "<space-code>";
    }
}

