/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.identifier;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSamplesWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletedSamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.GroupIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IdentifierHelper {
    private IdentifierHelper() {
    }

    public static final GroupIdentifier createGroupIdentifier(SpacePE groupPE) {
        assert (groupPE != null) : "Unspecified space";
        assert (groupPE.getDatabaseInstance() != null) : "Any space must be attached to a database instance";
        return new GroupIdentifier(IdentifierHelper.createDatabaseInstanceIdentifier(groupPE.getDatabaseInstance()), groupPE.getCode());
    }

    public static final DatabaseInstanceIdentifier createDatabaseInstanceIdentifier(DatabaseInstancePE databaseInstancePE) {
        assert (databaseInstancePE != null) : "Unspecified database instance";
        if (databaseInstancePE.isOriginalSource()) {
            return DatabaseInstanceIdentifier.createHome();
        }
        return new DatabaseInstanceIdentifier(databaseInstancePE.getCode());
    }

    public static final SampleIdentifier createSampleIdentifier(SamplePE samplePE) {
        assert (samplePE != null) : "Unspecified sample";
        DatabaseInstancePE databaseInstance = samplePE.getDatabaseInstance();
        SpacePE group = samplePE.getSpace();
        String sampleCode = IdentifierHelper.extractCode(samplePE);
        return IdentifierHelper.createSampleIdentifier(databaseInstance, group, sampleCode);
    }

    public static final SampleIdentifier createSampleIdentifier(DeletedSamplePE deletedSamplePE) {
        assert (deletedSamplePE != null) : "Unspecified sample";
        DatabaseInstancePE databaseInstance = deletedSamplePE.getDatabaseInstance();
        SpacePE group = deletedSamplePE.getSpace();
        String sampleCode = deletedSamplePE.getCode();
        return IdentifierHelper.createSampleIdentifier(databaseInstance, group, sampleCode);
    }

    public static final SampleIdentifier createSampleIdentifier(DatabaseInstanceIdentifier databaseInstanceIdentifier, SpaceIdentifier spaceIdentifier, String sampleCode, String sampleContainerCode) {
        String fullSampleCode = IdentifierHelper.convertCode(sampleCode, sampleContainerCode);
        if (databaseInstanceIdentifier != null) {
            return new SampleIdentifier(databaseInstanceIdentifier, fullSampleCode);
        }
        if (spaceIdentifier != null) {
            return new SampleIdentifier(spaceIdentifier, fullSampleCode);
        }
        return SampleIdentifier.createHomeGroup(fullSampleCode);
    }

    private static SampleIdentifier createSampleIdentifier(DatabaseInstancePE databaseInstance, SpacePE group, String sampleCode) {
        if (databaseInstance != null) {
            return new SampleIdentifier(IdentifierHelper.createDatabaseInstanceIdentifier(databaseInstance), sampleCode);
        }
        if (group != null) {
            return new SampleIdentifier(IdentifierHelper.createGroupIdentifier(group), sampleCode);
        }
        return SampleIdentifier.createHomeGroup(sampleCode);
    }

    public static SampleIdentifier createSampleIdentifier(Sample sample) {
        assert (sample != null) : "Unspecified sample";
        Space space = sample.getSpace();
        if (space != null) {
            DatabaseInstanceIdentifier instanceIdentifier = space.getInstance().isHomeDatabase() ? DatabaseInstanceIdentifier.HOME_INSTANCE : new DatabaseInstanceIdentifier(space.getInstance().getCode());
            GroupIdentifier groupIdentifier = new GroupIdentifier(instanceIdentifier, space.getCode());
            return new SampleIdentifier(groupIdentifier, sample.getCode());
        }
        DatabaseInstanceIdentifier instanceIdentifier = sample.getDatabaseInstance().isHomeDatabase() ? DatabaseInstanceIdentifier.HOME_INSTANCE : new DatabaseInstanceIdentifier(sample.getDatabaseInstance().getCode());
        return new SampleIdentifier(instanceIdentifier, sample.getCode());
    }

    public static final String extractSubCode(SamplePE samplePE) {
        return samplePE.getCode();
    }

    public static final String convertSubCode(String sampleCode) {
        return sampleCode;
    }

    public static final String extractCode(SamplePE samplePE) {
        String code;
        String subCode = IdentifierHelper.extractSubCode(samplePE);
        if (samplePE.getContainer() != null && HibernateUtils.isInitialized(samplePE.getContainer())) {
            String containerCode = samplePE.getContainer().getCode();
            code = String.valueOf(containerCode) + ":" + subCode;
        } else {
            code = subCode;
        }
        return code;
    }

    public static final String convertCode(String sampleCode, String containerCodeOrNull) {
        String code;
        String subCode = IdentifierHelper.convertSubCode(sampleCode);
        if (containerCodeOrNull != null) {
            String containerCode = containerCodeOrNull;
            code = String.valueOf(containerCode) + ":" + subCode;
        } else {
            code = subCode;
        }
        return code;
    }

    public static final ProjectIdentifier createProjectIdentifier(ProjectPE project) {
        assert (project != null) : "Unspecified project";
        SpacePE group = project.getSpace();
        DatabaseInstancePE databaseInstance = group.getDatabaseInstance();
        String instanceCode = databaseInstance.isOriginalSource() ? null : databaseInstance.getCode();
        ProjectIdentifier identifier = new ProjectIdentifier(instanceCode, group.getCode(), project.getCode());
        return identifier;
    }

    public static final ExperimentIdentifier createExperimentIdentifier(ExperimentPE experiment) {
        assert (experiment != null) : "Unspecified experiment";
        ExperimentIdentifier experimentIdentifier = new ExperimentIdentifier(IdentifierHelper.createProjectIdentifier(experiment.getProject()), experiment.getCode());
        return experimentIdentifier;
    }

    public static final List<SampleIdentifier> extractSampleIdentifiers(NewExperiment newExperiment) {
        ArrayList<SampleIdentifier> result = new ArrayList<SampleIdentifier>();
        for (NewSamplesWithTypes samplesWithTypes : newExperiment.getNewSamples()) {
            for (NewSample sample : samplesWithTypes.getNewEntities()) {
                SampleIdentifier identifier = SampleIdentifierFactory.parse(sample);
                if (identifier.tryGetContainerCode() == null && !StringUtils.isEmpty((String)sample.getContainerIdentifier())) {
                    SampleIdentifier containerIdentifier = SampleIdentifierFactory.parse(sample.getContainerIdentifier());
                    identifier.addContainerCode(containerIdentifier.getSampleCode());
                }
                result.add(identifier);
            }
        }
        return result;
    }

    public static final List<SampleIdentifier> extractSampleIdentifiers(String[] samples, String defaultSpace) {
        ArrayList<SampleIdentifier> sampleIdentifiers = new ArrayList<SampleIdentifier>();
        String[] stringArray = samples;
        int n = samples.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            sampleIdentifiers.add(SampleIdentifierFactory.parse(s, defaultSpace));
            ++n2;
        }
        return sampleIdentifiers;
    }

    public static void fillAndCheckGroup(SampleIdentifier sample, String expectedGroupCode) {
        if (sample.isDatabaseInstanceLevel()) {
            return;
        }
        if (!sample.isInsideHomeSpace()) {
            if (sample.getSpaceLevel().getSpaceCode().equalsIgnoreCase(expectedGroupCode)) {
                return;
            }
            throw new UserFailureException(String.format("Sample '%s' does not belong to the space '%s'", sample, expectedGroupCode));
        }
        sample.getSpaceLevel().setSpaceCode(expectedGroupCode);
    }

    public static void fillSpaceIfNotSpecified(SampleIdentifier sample, String defaultSpaceCode) {
        if (sample.isInsideHomeSpace()) {
            sample.getSpaceLevel().setSpaceCode(defaultSpaceCode);
        }
    }
}

