/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.identifier;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicProjectIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class ProjectIdentifier
extends SpaceIdentifier {
    private static final long serialVersionUID = 32L;
    private String projectCode;

    public ProjectIdentifier(String instanceCode, String spaceCode, String projectCode) {
        super(instanceCode, spaceCode);
        this.setProjectCode(projectCode);
    }

    public ProjectIdentifier(String spaceCode, String projectCode) {
        this(DatabaseInstanceIdentifier.HOME, spaceCode, projectCode);
    }

    public ProjectIdentifier(SpaceIdentifier spaceIdentifier, String projectCode) {
        this(spaceIdentifier.getDatabaseInstanceCode(), spaceIdentifier.getSpaceCode(), projectCode);
    }

    public ProjectIdentifier(BasicProjectIdentifier identifier) {
        this(identifier.getInstanceCode(), identifier.getSpaceCode(), identifier.getProjectCode());
    }

    public String getProjectCode() {
        return StringUtils.upperCase((String)this.projectCode);
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ProjectIdentifier)) {
            return false;
        }
        ProjectIdentifier that = (ProjectIdentifier)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getDatabaseInstanceCode(), (Object)that.getDatabaseInstanceCode());
        builder.append((Object)this.getSpaceCode(), (Object)that.getSpaceCode());
        builder.append((Object)this.getProjectCode(), (Object)that.getProjectCode());
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getDatabaseInstanceCode());
        builder.append((Object)this.getSpaceCode());
        builder.append((Object)this.getProjectCode());
        return builder.toHashCode();
    }

    public String toString() {
        if (this.getSpaceCode() == null) {
            return this.projectCode;
        }
        return String.valueOf(super.toString()) + '/' + this.projectCode;
    }
}

