/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.identifier;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.AbstractIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.GroupIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.GroupIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ProjectIdentifier;

public final class ProjectIdentifierFactory
extends AbstractIdentifierFactory {
    public ProjectIdentifierFactory(String textToParse) {
        super(textToParse);
    }

    public final ProjectIdentifier createIdentifier() throws UserFailureException {
        return ProjectIdentifierFactory.parseProjectIdentifier(this.getTextToParse(), null);
    }

    public final ProjectIdentifier createIdentifier(String defaultSpace) throws UserFailureException {
        return ProjectIdentifierFactory.parseProjectIdentifier(this.getTextToParse(), defaultSpace);
    }

    private static ProjectIdentifier parseProjectIdentifier(String text, String defaultSpace) {
        AbstractIdentifierFactory.TokenLexer lexer = new AbstractIdentifierFactory.TokenLexer(text);
        ProjectIdentifier projectIdentifier = ProjectIdentifierFactory.parseIdentifier(lexer, defaultSpace);
        lexer.ensureNoTokensLeft();
        return projectIdentifier;
    }

    public static ProjectIdentifier parseIdentifier(AbstractIdentifierFactory.TokenLexer lexer, String defaultSpace) {
        GroupIdentifier groupIdentifier = ProjectIdentifierFactory.parseGroup(lexer, defaultSpace);
        String projectCode = ProjectIdentifierFactory.assertValidCode(lexer.next());
        return ProjectIdentifierFactory.create(groupIdentifier, projectCode);
    }

    private static GroupIdentifier parseGroup(AbstractIdentifierFactory.TokenLexer lexer, String defaultSpace) {
        String firstToken = lexer.peek();
        if (ProjectIdentifierFactory.tryAsDatabaseIdentifier(firstToken) == null && firstToken.length() > 0) {
            if (defaultSpace == null) {
                return GroupIdentifier.createHome();
            }
            return new GroupIdentifierFactory(defaultSpace).createIdentifier();
        }
        return GroupIdentifierFactory.parseIdentifier(lexer);
    }

    private static ProjectIdentifier create(GroupIdentifier groupIdentifier, String projectCode) {
        return new ProjectIdentifier(groupIdentifier.getDatabaseInstanceCode(), groupIdentifier.getSpaceCode(), projectCode);
    }

    public static String getSchema() {
        return "[" + GroupIdentifierFactory.getSchema() + '/' + "]" + "<project-code>";
    }
}

