/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.identifier;

import ch.systemsx.cisd.common.exceptions.InternalErr;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.GroupIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;

public class SampleIdentifier
extends SampleOwnerIdentifier {
    private static final long serialVersionUID = 32L;
    public static final String CONTAINED_SAMPLE_CODE_SEPARARTOR_STRING = ":";
    public static final SampleIdentifier[] EMPTY_ARRAY = new SampleIdentifier[0];
    private String sampleCode;
    private String sampleSubCode;
    private String containerCodeOrNull;

    private SampleIdentifier(DatabaseInstanceIdentifier databaseInstanceIdentOrNull, SpaceIdentifier spaceIdentOrNull, String sampleCode) {
        super(databaseInstanceIdentOrNull, spaceIdentOrNull);
        this.setSampleCode(sampleCode);
    }

    public static SampleIdentifier createOwnedBy(SampleOwnerIdentifier owner, String sampleCode) {
        if (owner.isDatabaseInstanceLevel()) {
            return new SampleIdentifier(owner.getDatabaseInstanceLevel(), sampleCode);
        }
        if (owner.isSpaceLevel()) {
            return new SampleIdentifier(owner.getSpaceLevel(), sampleCode);
        }
        throw InternalErr.error();
    }

    public SampleIdentifier(DatabaseInstanceIdentifier instanceIdentifier, String sampleCode) {
        this(instanceIdentifier, null, sampleCode);
    }

    public SampleIdentifier(SpaceIdentifier spaceIdentifier, String sampleCode) {
        this(null, spaceIdentifier, sampleCode);
    }

    public static SampleIdentifier create(String spaceCode, String sampleCode) {
        return new SampleIdentifier(new SpaceIdentifier(spaceCode), sampleCode);
    }

    public static SampleIdentifier createHomeGroup(String sampleCode) {
        return new SampleIdentifier(GroupIdentifier.createHome(), sampleCode);
    }

    public String getSampleCode() {
        return this.sampleCode;
    }

    public String getSampleSubCode() {
        return this.sampleSubCode;
    }

    public String tryGetContainerCode() {
        return this.containerCodeOrNull;
    }

    public SampleOwnerIdentifier createSampleOwnerIdentifier() {
        return new SampleOwnerIdentifier(this.getDatabaseInstanceLevel(), this.getSpaceLevel());
    }

    public String toString() {
        return String.valueOf(super.toString()) + this.sampleCode;
    }

    @Deprecated
    public void setSampleCode(String sampleCode) {
        this.sampleCode = sampleCode;
        if (sampleCode != null) {
            String[] sampleCodeTokens = sampleCode.split(CONTAINED_SAMPLE_CODE_SEPARARTOR_STRING);
            this.sampleSubCode = sampleCodeTokens[sampleCodeTokens.length - 1];
            if (sampleCodeTokens.length > 1) {
                this.containerCodeOrNull = sampleCodeTokens[0];
            }
        } else {
            this.sampleSubCode = sampleCode;
        }
    }

    public void addContainerCode(String containerCode) {
        assert (containerCode != null);
        assert (!containerCode.contains(CONTAINED_SAMPLE_CODE_SEPARARTOR_STRING));
        assert (this.sampleSubCode.equals(this.sampleCode));
        this.setSampleCode(String.valueOf(containerCode) + CONTAINED_SAMPLE_CODE_SEPARARTOR_STRING + this.sampleSubCode);
    }

    @Deprecated
    public SampleIdentifier() {
        super(null, null);
    }

    public final int compareTo(SampleOwnerIdentifier o) {
        int ownerCmp = super.compareTo(o);
        if (ownerCmp == 0) {
            return this.sampleCode.compareTo(((SampleIdentifier)o).sampleCode);
        }
        return ownerCmp;
    }
}

