/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.identifier;

import ch.systemsx.cisd.common.utilities.AbstractHashable;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.GroupIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleOwnerIdentifier;
import java.io.Serializable;

public class SampleIdentifierPattern
extends AbstractHashable
implements Serializable {
    public static final SampleIdentifierPattern[] EMPTY_ARRAY = new SampleIdentifierPattern[0];
    private static final long serialVersionUID = 32L;
    private final SampleOwnerIdentifier owner;
    private final String sampleCodePattern;

    public static SampleIdentifierPattern[] createGroupVisible(GroupIdentifier groupIdentifier, String sampleCodePattern) {
        SampleOwnerIdentifier groupOwner = new SampleOwnerIdentifier(groupIdentifier);
        SampleIdentifierPattern groupPattern = new SampleIdentifierPattern(sampleCodePattern, groupOwner);
        SampleOwnerIdentifier dbOwner = new SampleOwnerIdentifier((DatabaseInstanceIdentifier)groupIdentifier);
        SampleIdentifierPattern dbPattern = new SampleIdentifierPattern(sampleCodePattern, dbOwner);
        return new SampleIdentifierPattern[]{groupPattern, dbPattern};
    }

    public static SampleIdentifierPattern createOwnedBy(SampleOwnerIdentifier owner, String sampleCodePattern) {
        return new SampleIdentifierPattern(sampleCodePattern, owner);
    }

    private SampleIdentifierPattern(String sampleCodePattern, SampleOwnerIdentifier owner) {
        this.owner = owner;
        this.sampleCodePattern = sampleCodePattern;
    }

    public SampleOwnerIdentifier getSampleOwner() {
        return this.owner;
    }

    public String getSampleCodePattern() {
        return this.sampleCodePattern;
    }

    public String toString() {
        return String.valueOf(this.owner.toString()) + this.sampleCodePattern;
    }
}

