/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto.identifier;

import ch.systemsx.cisd.common.utilities.AbstractHashable;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.DatabaseInstanceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleOwnerIdentifier
extends AbstractHashable
implements Serializable,
Comparable<SampleOwnerIdentifier> {
    private static final long serialVersionUID = 32L;
    private SpaceIdentifier spaceIdentOrNull;
    private DatabaseInstanceIdentifier databaseInstanceIdentOrNull;

    protected SampleOwnerIdentifier(DatabaseInstanceIdentifier databaseInstanceIdentOrNull, SpaceIdentifier spaceIdentOrNull) {
        this.databaseInstanceIdentOrNull = databaseInstanceIdentOrNull;
        this.spaceIdentOrNull = spaceIdentOrNull;
    }

    public SampleOwnerIdentifier(DatabaseInstanceIdentifier instanceIdentifier) {
        this(SampleOwnerIdentifier.checkNotNull(instanceIdentifier), null);
    }

    private static DatabaseInstanceIdentifier checkNotNull(DatabaseInstanceIdentifier identifier) {
        assert (identifier != null) : "database identifier cannot be null";
        return identifier;
    }

    public SampleOwnerIdentifier(SpaceIdentifier groupIdentifier) {
        this(null, SampleOwnerIdentifier.checkNotNull(groupIdentifier));
    }

    private static SpaceIdentifier checkNotNull(SpaceIdentifier identifier) {
        assert (identifier != null) : "space identifier cannot be null";
        return identifier;
    }

    public boolean isInsideHomeSpace() {
        return this.isSpaceLevel() && this.spaceIdentOrNull.isHomeSpace();
    }

    public boolean isSpaceLevel() {
        return this.spaceIdentOrNull != null;
    }

    public boolean isDatabaseInstanceLevel() {
        return this.databaseInstanceIdentOrNull != null;
    }

    @Override
    public String toString() {
        if (this.isSpaceLevel()) {
            if (this.isInsideHomeSpace()) {
                return "";
            }
            return String.valueOf(this.spaceIdentOrNull.toString()) + '/';
        }
        if (this.isDatabaseInstanceLevel()) {
            if (this.databaseInstanceIdentOrNull.isHomeDatabase()) {
                return "/";
            }
            return String.valueOf(this.databaseInstanceIdentOrNull.getDatabaseInstanceCode()) + ':' + '/';
        }
        throw new IllegalStateException("sample owner is unknown");
    }

    public DatabaseInstanceIdentifier getDatabaseInstanceLevel() {
        return this.databaseInstanceIdentOrNull;
    }

    public SpaceIdentifier getSpaceLevel() {
        return this.spaceIdentOrNull;
    }

    @Override
    public int compareTo(SampleOwnerIdentifier other) {
        if (this.isSpaceLevel()) {
            if (other.isSpaceLevel()) {
                return this.getSpaceLevel().compareTo(other.getSpaceLevel());
            }
            return 1;
        }
        if (this.isDatabaseInstanceLevel()) {
            if (other.isSpaceLevel()) {
                return -1;
            }
            return this.getDatabaseInstanceLevel().compareTo(other.getDatabaseInstanceLevel());
        }
        throw new IllegalStateException("sample owner is unknown");
    }
}

