/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.managed_property;

import ch.systemsx.cisd.common.evaluator.Evaluator;
import ch.systemsx.cisd.common.evaluator.EvaluatorException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.api.IManagedUiAction;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.ManagedPropertyFunctions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagedPropertyEvaluator {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ManagedPropertyEvaluator.class);
    private static final String CONFIGURE_UI_FUNCTION = "configureUI";
    private static final String UPDATE_FROM_UI_FUNCTION = "updateFromUI";
    private static final String BATCH_COLUMN_NAMES_FUNCTION = "batchColumnNames";
    private static final String UPDATE_FROM_BATCH_INPUT_FUNCTION = "updateFromBatchInput";
    private static final String PROPERTY_VARIABLE_NAME = "property";
    private static final String PROPERTY_PE_VARIABLE_NAME = "propertyPE";
    private final Evaluator evaluator;
    private final List<String> columnNames;
    private final boolean updateFromBatchFunctionDefined;

    public ManagedPropertyEvaluator(String scriptExpression) {
        this.evaluator = new Evaluator("", ManagedPropertyFunctions.class, scriptExpression);
        this.updateFromBatchFunctionDefined = this.evaluator.hasFunction(UPDATE_FROM_BATCH_INPUT_FUNCTION);
        ArrayList<String> names = new ArrayList<String>();
        if (this.evaluator.hasFunction(BATCH_COLUMN_NAMES_FUNCTION)) {
            if (!this.updateFromBatchFunctionDefined) {
                throw new EvaluatorException("Function 'batchColumnNames' defined but not 'updateFromBatchInput'.");
            }
            Object result = this.evaluator.evalFunction(BATCH_COLUMN_NAMES_FUNCTION, new Object[0]);
            if (!(result instanceof List)) {
                throw new EvaluatorException("Function 'batchColumnNames' doesn't return a List but an object of type '" + result.getClass().getName() + "': " + result);
            }
            List list = (List)result;
            ArrayList<String> notUpperCaseNames = new ArrayList<String>();
            for (Object element : list) {
                String columnName = element.toString();
                if (!columnName.toUpperCase().equals(columnName)) {
                    notUpperCaseNames.add(columnName);
                }
                names.add(columnName);
            }
            if (!notUpperCaseNames.isEmpty()) {
                throw new EvaluatorException("The following batch column names as returned by function 'batchColumnNames' are not in upper case: " + notUpperCaseNames);
            }
        }
        this.columnNames = Collections.unmodifiableList(names);
    }

    public void configureUI(IManagedProperty managedProperty, EntityPropertyPE entityPropertyPE) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Evaluating managed property ui configuration'%s'.", managedProperty));
        }
        this.evaluator.set(PROPERTY_VARIABLE_NAME, managedProperty);
        this.evaluator.set(PROPERTY_PE_VARIABLE_NAME, entityPropertyPE);
        this.evaluator.evalFunction(CONFIGURE_UI_FUNCTION, new Object[0]);
    }

    public void updateFromUI(IManagedProperty managedProperty, IManagedUiAction action) {
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("Evaluating managed property value update '%s'.", managedProperty));
        }
        this.evaluator.set(PROPERTY_VARIABLE_NAME, managedProperty);
        this.evaluator.evalFunction(UPDATE_FROM_UI_FUNCTION, action);
    }

    public List<String> getBatchColumnNames() {
        return this.columnNames;
    }

    public void updateFromBatchInput(IManagedProperty managedProperty, Map<String, String> bindings) {
        if (!this.updateFromBatchFunctionDefined) {
            if (bindings.containsKey("")) {
                managedProperty.setValue(bindings.get(""));
            }
        } else {
            this.evaluator.set(PROPERTY_VARIABLE_NAME, managedProperty);
            this.evaluator.evalFunction(UPDATE_FROM_BATCH_INPUT_FUNCTION, bindings);
        }
    }
}

