/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.managed_property.structured;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.EntityLinkElementKind;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IElement;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IElementFactory;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.IEntityLinkElement;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.structured.Element;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.structured.EntityLinkElement;

public class ElementFactory
implements IElementFactory {
    public IElement createElement(String name) {
        if (EntityLinkElementKind.tryGetForElementName(name) != null) {
            String error = String.format("The name %s is reseved for link elements.", name);
            throw new IllegalArgumentException(error);
        }
        return new Element(name);
    }

    public IEntityLinkElement createSampleLink(String permId) {
        return new EntityLinkElement(EntityLinkElementKind.SAMPLE, permId);
    }

    public IEntityLinkElement createExperimentLink(String permId) {
        return new EntityLinkElement(EntityLinkElementKind.EXPERIMENT, permId);
    }

    public IEntityLinkElement createDataSetLink(String permId) {
        return new EntityLinkElement(EntityLinkElementKind.DATA_SET, permId);
    }

    public IEntityLinkElement createMaterialLink(String code, String typeCode) {
        String materialPermId = MaterialIdentifier.print(code, typeCode);
        return new EntityLinkElement(EntityLinkElementKind.MATERIAL, materialPermId);
    }

    public boolean isEntityLink(IElement element) {
        return element instanceof IEntityLinkElement;
    }
}

