/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.translator.MaterialTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PropertyTranslatorUtils;
import ch.systemsx.cisd.openbis.generic.shared.translator.PropertyTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.VocabularyTermTranslator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EntityPropertyTranslator {
    private EntityPropertyTranslator() {
    }

    public static final IEntityProperty translate(EntityPropertyPE propertyPE, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        return EntityPropertyTranslator.translate(propertyPE, cacheOrNull, false);
    }

    public static final IEntityProperty translate(EntityPropertyPE propertyPE, Map<PropertyTypePE, PropertyType> cacheOrNull, boolean rawManagedProperties) {
        IEntityProperty result;
        IEntityProperty basicProperty = PropertyTranslatorUtils.createEntityProperty(propertyPE);
        PropertyType propertyType = PropertyTypeTranslator.translate(propertyPE.getEntityTypePropertyType().getPropertyType(), cacheOrNull);
        Long ordinal = propertyPE.getEntityTypePropertyType().getOrdinal();
        PropertyTranslatorUtils.initializeEntityProperty(basicProperty, propertyType, ordinal);
        DataTypeCode typeCode = PropertyTranslatorUtils.getDataTypeCode(propertyPE);
        switch (typeCode) {
            case CONTROLLEDVOCABULARY: {
                basicProperty.setVocabularyTerm(VocabularyTermTranslator.translate(propertyPE.getVocabularyTerm()));
                break;
            }
            case MATERIAL: {
                basicProperty.setMaterial(MaterialTranslator.translate(propertyPE.getMaterialValue(), false));
                break;
            }
            default: {
                basicProperty.setValue(propertyPE.tryGetUntypedValue());
            }
        }
        if (propertyPE.getEntityTypePropertyType().isManaged() && !rawManagedProperties) {
            result = PropertyTranslatorUtils.createManagedEntityProperty(propertyPE, basicProperty);
            PropertyTranslatorUtils.initializeEntityProperty(result, propertyType, ordinal);
        } else {
            result = basicProperty;
        }
        return result;
    }

    public static final List<IEntityProperty> translateRaw(Set<? extends EntityPropertyPE> list, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        if (list == null) {
            return null;
        }
        ArrayList<IEntityProperty> result = new ArrayList<IEntityProperty>();
        for (EntityPropertyPE entityPropertyPE : list) {
            result.add(EntityPropertyTranslator.translate(entityPropertyPE, cacheOrNull, true));
        }
        return result;
    }

    public static final List<IEntityProperty> translate(Set<? extends EntityPropertyPE> list, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        if (list == null) {
            return null;
        }
        ArrayList<IEntityProperty> result = new ArrayList<IEntityProperty>();
        for (EntityPropertyPE entityPropertyPE : list) {
            result.add(EntityPropertyTranslator.translate(entityPropertyPE, cacheOrNull));
        }
        return result;
    }

    public static final IEntityProperty[] translate(EntityPropertyPE[] list, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        if (list == null) {
            return null;
        }
        IEntityProperty[] result = new IEntityProperty[list.length];
        int idx = 0;
        EntityPropertyPE[] entityPropertyPEArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            EntityPropertyPE property = entityPropertyPEArray[n2];
            result[idx++] = EntityPropertyTranslator.translate(property, cacheOrNull);
            ++n2;
        }
        return result;
    }
}

