/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.translator.DatabaseInstanceTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.EntityPropertyTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.MaterialTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MaterialTranslator {
    private MaterialTranslator() {
    }

    public static final List<Material> translate(List<MaterialPE> materials) {
        ArrayList<Material> result = new ArrayList<Material>();
        for (MaterialPE material : materials) {
            result.add(MaterialTranslator.translate(material));
        }
        return result;
    }

    public static final Material translate(MaterialPE materialPE) {
        return MaterialTranslator.translate(materialPE, true);
    }

    public static final Material translate(MaterialPE materialPE, boolean withProperties) {
        if (materialPE == null) {
            return null;
        }
        Material result = new Material();
        result.setCode(materialPE.getCode());
        result.setId(HibernateUtils.getId(materialPE));
        result.setModificationDate(materialPE.getModificationDate());
        result.setMaterialType(MaterialTypeTranslator.translate(materialPE.getMaterialType(), new HashMap<PropertyTypePE, PropertyType>()));
        result.setDatabaseInstance(DatabaseInstanceTranslator.translate(materialPE.getDatabaseInstance()));
        result.setRegistrator(PersonTranslator.translate(materialPE.getRegistrator()));
        result.setRegistrationDate(materialPE.getRegistrationDate());
        if (withProperties) {
            MaterialTranslator.setProperties(materialPE, result);
        }
        return result;
    }

    private static void setProperties(MaterialPE materialPE, Material result) {
        if (materialPE.isPropertiesInitialized()) {
            result.setProperties(EntityPropertyTranslator.translate(materialPE.getProperties(), new HashMap<PropertyTypePE, PropertyType>()));
        } else {
            result.setProperties(new ArrayList<IEntityProperty>());
        }
    }
}

