/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.common.evaluator.EvaluatorException;
import ch.systemsx.cisd.openbis.generic.shared.basic.BasicConstant;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.GenericEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ManagedEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ScriptPE;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.ManagedPropertyEvaluator;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.ManagedPropertyEvaluatorFactory;

final class PropertyTranslatorUtils {
    private PropertyTranslatorUtils() {
    }

    private static DataTypeCode translateDataTypeCode(EntityTypePropertyTypePE etpt) {
        return DataTypeCode.valueOf(etpt.getPropertyType().getType().getCode().name());
    }

    static DataTypeCode getDataTypeCode(EntityPropertyPE property) {
        return PropertyTranslatorUtils.translateDataTypeCode(property.getEntityTypePropertyType());
    }

    static IEntityProperty createEntityProperty(EntityPropertyPE propertyPE) {
        DataTypeCode typeCode = PropertyTranslatorUtils.getDataTypeCode(propertyPE);
        AbstractEntityProperty basicProperty = PropertyTranslatorUtils.createEntityProperty(typeCode);
        basicProperty.setScriptable(propertyPE.getEntityTypePropertyType().isScriptable());
        return basicProperty;
    }

    static IEntityProperty createManagedEntityProperty(EntityPropertyPE property, IEntityProperty basicProperty) {
        ScriptPE script = property.getEntityTypePropertyType().getScript();
        assert (script != null && script.getScriptType() == ScriptType.MANAGED_PROPERTY);
        ManagedEntityProperty result = new ManagedEntityProperty(basicProperty);
        try {
            ManagedPropertyEvaluator evaluator = ManagedPropertyEvaluatorFactory.createManagedPropertyEvaluator(script.getScript());
            evaluator.configureUI(result, property);
        }
        catch (EvaluatorException ex) {
            result.setValue(String.valueOf(BasicConstant.ERROR_PROPERTY_PREFIX) + ex.getMessage());
        }
        return result;
    }

    static void initializeEntityProperty(IEntityProperty property, PropertyType propertyType, Long ordinal) {
        property.setPropertyType(propertyType);
        property.setOrdinal(ordinal);
    }

    private static AbstractEntityProperty createEntityProperty(DataTypeCode dataTypeCode) {
        switch (dataTypeCode) {
            case CONTROLLEDVOCABULARY: {
                return new VocabularyTermEntityProperty();
            }
            case MATERIAL: {
                return new MaterialEntityProperty();
            }
        }
        return new GenericEntityProperty();
    }
}

