/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.PermlinkUtilities;
import ch.systemsx.cisd.openbis.generic.shared.basic.SearchlinkUtilities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Attachment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleParentWithDerived;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleParentWithDerivedDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.translator.AttachmentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DatabaseInstanceTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DeletionTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DtoConverters;
import ch.systemsx.cisd.openbis.generic.shared.translator.EntityPropertyTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SpaceTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SampleTranslator {
    private SampleTranslator() {
    }

    public static List<Sample> translate(List<SamplePE> samples, String baseIndexURL) {
        ArrayList<Sample> list = new ArrayList<Sample>(samples.size());
        for (SamplePE sample : samples) {
            list.add(SampleTranslator.translate(sample, baseIndexURL));
        }
        return list;
    }

    public static final Sample translate(SamplePE samplePE, String baseIndexURL) {
        return SampleTranslator.translate(samplePE, baseIndexURL, true, false);
    }

    public static final Sample translate(SamplePE samplePE, String baseIndexURL, boolean withDetails, boolean withContainedSamples) {
        if (samplePE == null) {
            return null;
        }
        int containerDep = SampleTranslator.getPositiveIntegerValue(samplePE.getSampleType().getContainerHierarchyDepth());
        int generatedFromDep = SampleTranslator.getPositiveIntegerValue(samplePE.getSampleType().getGeneratedFromHierarchyDepth());
        return SampleTranslator.translate(samplePE, baseIndexURL, containerDep, generatedFromDep, withDetails, withContainedSamples);
    }

    private static final Sample translate(SamplePE samplePE, String baseIndexURL, int containerDep, int generatedFromDep, boolean withDetails, boolean withContainedSamples) {
        Sample result = new Sample();
        SampleTranslator.setCodes(result, samplePE);
        result.setPermId(samplePE.getPermId());
        result.setPermlink(PermlinkUtilities.createPermlinkURL(baseIndexURL, EntityKind.SAMPLE, samplePE.getPermId()));
        result.setSearchlink(SearchlinkUtilities.createSearchlinkURL(baseIndexURL, EntityKind.SAMPLE, samplePE.getCode()));
        result.setModificationDate(samplePE.getModificationDate());
        result.setId(HibernateUtils.getId(samplePE));
        result.setIdentifier(samplePE.getIdentifier());
        result.setSampleType(SampleTypeTranslator.translate(samplePE.getSampleType(), new HashMap<PropertyTypePE, PropertyType>()));
        if (withDetails) {
            result.setSpace(SpaceTranslator.translate(samplePE.getSpace()));
            result.setDatabaseInstance(DatabaseInstanceTranslator.translate(samplePE.getDatabaseInstance()));
            result.setRegistrator(PersonTranslator.translate(samplePE.getRegistrator()));
            result.setRegistrationDate(samplePE.getRegistrationDate());
            SampleTranslator.setProperties(result, samplePE);
            result.setExperiment(ExperimentTranslator.translate(samplePE.getExperiment(), baseIndexURL, ExperimentTranslator.LoadableFields.PROPERTIES));
            List<Attachment> attachments = !samplePE.attachmentsInitialized() ? DtoConverters.createUnmodifiableEmptyList() : AttachmentTranslator.translate(samplePE.getAttachments(), baseIndexURL);
            result.setAttachments(attachments);
        }
        if (containerDep > 0 && samplePE.getContainer() != null && HibernateUtils.isInitialized(samplePE.getContainer())) {
            result.setContainer(SampleTranslator.translate(samplePE.getContainer(), baseIndexURL, containerDep - 1, 0, false, false));
        }
        if (generatedFromDep > 0 && samplePE.getParentRelationships() != null && HibernateUtils.isInitialized(samplePE.getParentRelationships())) {
            for (SamplePE parent : samplePE.getParents()) {
                result.addParent(SampleTranslator.translate(parent, baseIndexURL, 0, generatedFromDep - 1, false, false));
            }
        }
        if (withContainedSamples && samplePE.getContained() != null) {
            ArrayList<Sample> containedSamples = new ArrayList<Sample>();
            for (SamplePE containedPE : samplePE.getContained()) {
                Sample containedSample = SampleTranslator.translate(containedPE, baseIndexURL, 0, 0, false, false);
                containedSamples.add(containedSample);
            }
            result.setContainedSample(containedSamples);
        }
        result.setDeletion(DeletionTranslator.translate(samplePE.getDeletion()));
        return result;
    }

    public static void setCodes(Sample result, SamplePE samplePE) {
        result.setSubCode(IdentifierHelper.extractSubCode(samplePE));
        result.setCode(IdentifierHelper.extractCode(samplePE));
    }

    private static void setProperties(Sample result, SamplePE samplePE) {
        if (samplePE.isPropertiesInitialized()) {
            result.setProperties(EntityPropertyTranslator.translate(samplePE.getProperties(), new HashMap<PropertyTypePE, PropertyType>()));
        } else {
            result.setProperties(new ArrayList<IEntityProperty>());
        }
    }

    public static final SampleParentWithDerived translate(SampleParentWithDerivedDTO sampleGenerationDTO, String baseIndexURL) {
        SampleParentWithDerived sampleGeneration = new SampleParentWithDerived();
        sampleGeneration.setParent(SampleTranslator.translate(sampleGenerationDTO.getParent(), baseIndexURL));
        ArrayList<Sample> generated = new ArrayList<Sample>();
        SamplePE[] samplePEArray = sampleGenerationDTO.getDerived();
        int n = samplePEArray.length;
        int n2 = 0;
        while (n2 < n) {
            SamplePE samplePE = samplePEArray[n2];
            generated.add(SampleTranslator.translate(samplePE, baseIndexURL, false, false));
            ++n2;
        }
        sampleGeneration.setDerived(generated.toArray(new Sample[generated.size()]));
        return sampleGeneration;
    }

    public static final int getPositiveIntegerValue(int integer) {
        return integer == 0 ? 1 : integer;
    }
}

