/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.util;

import ch.systemsx.cisd.common.collections.CollectionUtils;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerUtils {
    public static <T> void prevalidate(List<T> entities, String entityName) {
        Collection<T> duplicated = ServerUtils.extractDuplicatedElements(entities);
        if (duplicated.size() > 0) {
            throw UserFailureException.fromTemplate("Following %s(s) '%s' are duplicated.", entityName, CollectionUtils.abbreviate(duplicated, 20));
        }
    }

    private static <T> Collection<T> extractDuplicatedElements(List<T> entities) {
        HashSet<T> entitiesSet = new HashSet<T>(entities);
        ArrayList<T> duplicated = new ArrayList<T>();
        for (T entity : entities) {
            if (entitiesSet.remove(entity)) continue;
            duplicated.add(entity);
        }
        return duplicated;
    }

    public static Set<String> extractSet(String commaSeparatedList) {
        HashSet<String> result = new HashSet<String>();
        if (commaSeparatedList != null && !commaSeparatedList.startsWith("$")) {
            String[] terms;
            String[] stringArray = terms = commaSeparatedList.split(",");
            int n = terms.length;
            int n2 = 0;
            while (n2 < n) {
                String term = stringArray[n2];
                result.add(term.trim());
                ++n2;
            }
        }
        return result;
    }
}

