/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.util;

import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.exception.UndefinedSpaceException;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;

public class SpaceCodeHelper {
    public static final String HOME_SPACE_CODE = null;

    private SpaceCodeHelper() {
    }

    public static boolean isHomeSpace(String spaceCodeOrNull) {
        return spaceCodeOrNull == HOME_SPACE_CODE;
    }

    public static final String getSpaceCode(PersonPE person, SpaceIdentifier spaceIdentifier) throws UndefinedSpaceException {
        return SpaceCodeHelper.getSpaceCode(person, spaceIdentifier.getSpaceCode());
    }

    public static final String getSpaceCode(PersonPE person, SpacePE group) throws UndefinedSpaceException {
        return SpaceCodeHelper.getSpaceCode(person, group.getCode());
    }

    public static final String getSpaceCode(PersonPE person, String spaceCode) throws UndefinedSpaceException {
        if (SpaceCodeHelper.isHomeSpace(spaceCode)) {
            SpacePE homeGroup = person.getHomeSpace();
            if (homeGroup == null) {
                throw new UndefinedSpaceException();
            }
            return homeGroup.getCode();
        }
        return spaceCode;
    }

    public static final String getSpaceCode(String homeSpaceCode, String spaceCode) throws UndefinedSpaceException {
        if (SpaceCodeHelper.isHomeSpace(spaceCode)) {
            if (homeSpaceCode == null) {
                throw new UndefinedSpaceException();
            }
            return homeSpaceCode;
        }
        return spaceCode;
    }
}

