/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.util;

import ch.systemsx.cisd.openbis.generic.shared.basic.DeletionUtils;
import ch.systemsx.cisd.openbis.generic.shared.basic.IEntityInformationHolderWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimplePersonRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.TableCellUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DateTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DoubleTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IntegerTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.StringTableCell;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.VocabularyTermTableCell;
import ch.systemsx.cisd.openbis.generic.shared.util.DataTypeUtils;
import ch.systemsx.cisd.openbis.generic.shared.util.IColumn;
import ch.systemsx.cisd.openbis.generic.shared.util.IColumnGroup;
import ch.systemsx.cisd.openbis.generic.shared.util.IColumnMetaData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypedTableModelBuilder<T extends Serializable> {
    private static final StringTableCell EMPTY_CELL = new StringTableCell("");
    private final Map<String, Column> columns = new HashMap<String, Column>();
    private final Map<String, IColumnGroup> columnGroups = new HashMap<String, IColumnGroup>();
    private final List<IColumnItem> columnItems = new ArrayList<IColumnItem>();
    private final List<T> rowObjects = new ArrayList<T>();

    public TypedTableModel<T> getModel() {
        ArrayList orderedColumns = new ArrayList();
        for (IColumnItem item : this.columnItems) {
            List<Column> itemColumns = item.getColumns();
            Collections.sort(itemColumns, new Comparator<Column>(){

                @Override
                public int compare(Column c1, Column c2) {
                    String t1 = StringUtils.trimToEmpty((String)c1.getHeader().getTitle());
                    String t2 = StringUtils.trimToEmpty((String)c2.getHeader().getTitle());
                    return t1.compareTo(t2);
                }
            });
            orderedColumns.addAll(itemColumns);
        }
        int i = 0;
        while (i < orderedColumns.size()) {
            TableModelColumnHeader header = ((Column)orderedColumns.get(i)).getHeader();
            header.setIndex(i);
            ++i;
        }
        ArrayList<TableModelColumnHeader> headers = new ArrayList<TableModelColumnHeader>();
        for (Column column : orderedColumns) {
            headers.add(column.getHeader());
        }
        ArrayList rows = new ArrayList();
        int i2 = 0;
        int n = this.rowObjects.size();
        while (i2 < n) {
            Serializable object = (Serializable)this.rowObjects.get(i2);
            ArrayList<ISerializableComparable> rowValues = new ArrayList<ISerializableComparable>(headers.size());
            for (Column column : orderedColumns) {
                rowValues.add(column.getValue(i2));
            }
            rows.add(new TableModelRowWithObject<Serializable>(object, rowValues));
            ++i2;
        }
        return new TypedTableModel(headers, rows);
    }

    public IColumnMetaData addColumn(String id) {
        if (this.columns.containsKey(id)) {
            throw new IllegalArgumentException("There is already a column with id '" + id + "'.");
        }
        Column column = this.getOrCreateColumnAsColumnItem(id);
        return new ColumnMetaData(column);
    }

    public void addRow(T objectOrNull) {
        this.rowObjects.add(objectOrNull);
    }

    public IColumnGroup columnGroup(String groupKey) {
        IColumnGroup columnGroup = this.columnGroups.get(groupKey);
        if (columnGroup == null) {
            ColumnGroup group = new ColumnGroup(groupKey);
            this.columnItems.add(group);
            columnGroup = group;
            this.columnGroups.put(groupKey, columnGroup);
        }
        return columnGroup;
    }

    public IColumn column(String id) {
        return this.getOrCreateColumnAsColumnItem(id);
    }

    private Column getOrCreateColumnAsColumnItem(String id) {
        boolean knownColumn = this.columns.containsKey(id);
        Column column = this.getOrCreateColumn(id);
        if (!knownColumn) {
            this.columnItems.add(column);
        }
        return column;
    }

    private Column getOrCreateColumn(String id) {
        Column column = this.columns.get(id);
        if (column == null) {
            column = new Column(id, new IIndexProvider(){

                @Override
                public int getIndex() {
                    return TypedTableModelBuilder.this.rowObjects.size() - 1;
                }
            });
            this.columns.put(id, column);
        }
        return column;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Column
    implements IColumn,
    IColumnItem {
        private final TableModelColumnHeader header;
        private final List<ISerializableComparable> values = new ArrayList<ISerializableComparable>();
        private final IIndexProvider indexProvider;

        Column(String id, IIndexProvider indexProvider) {
            this.header = new TableModelColumnHeader(null, id, 0);
            this.indexProvider = indexProvider;
        }

        public TableModelColumnHeader getHeader() {
            return this.header;
        }

        public ISerializableComparable getValue(int index) {
            return index < this.values.size() ? this.values.get(index) : EMPTY_CELL;
        }

        @Override
        public List<Column> getColumns() {
            return new ArrayList<Column>(Arrays.asList(this));
        }

        @Override
        public IColumn withTitle(String title) {
            this.header.setTitle(title);
            return this;
        }

        @Override
        public IColumn withDefaultWidth(int width) {
            this.header.setDefaultColumnWidth(width);
            return this;
        }

        @Override
        public IColumn withDataType(DataTypeCode dataType) {
            this.header.setDataType(dataType);
            return this;
        }

        @Override
        public IColumn withEntityKind(EntityKind entityKind) {
            this.header.setEntityKind(entityKind);
            return this;
        }

        @Override
        public IColumn editable() {
            this.header.setEditable(true);
            return this;
        }

        @Override
        public IColumn property(String key, String value) {
            this.header.setProperty(key, value);
            return this;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public void addValue(ISerializableComparable valueOrNull) {
            index = this.indexProvider.getIndex();
            if (index >= 0) ** GOTO lbl6
            throw new IllegalStateException("Row index is < 0: This is most likely caused by missing invocation of builder.addRow().");
lbl-1000:
            // 1 sources

            {
                this.values.add(TypedTableModelBuilder.access$1());
lbl6:
                // 2 sources

                ** while (index > this.values.size())
            }
lbl7:
            // 1 sources

            this.values.add(index, valueOrNull);
        }

        @Override
        public void addString(String valueOrNull) {
            this.setDataType(DataTypeCode.VARCHAR);
            StringTableCell value = valueOrNull == null ? EMPTY_CELL : new StringTableCell(valueOrNull);
            this.addValue(value);
        }

        @Override
        public void addInteger(Long valueOrNull) {
            this.setDataType(DataTypeCode.INTEGER);
            ISerializableComparable value = valueOrNull == null ? EMPTY_CELL : new IntegerTableCell(valueOrNull);
            this.addValue(value);
        }

        @Override
        public void addDouble(Double valueOrNull) {
            this.setDataType(DataTypeCode.REAL);
            ISerializableComparable value = valueOrNull == null ? EMPTY_CELL : new DoubleTableCell(valueOrNull);
            this.addValue(value);
        }

        @Override
        public void addDate(Date valueOrNull) {
            this.setDataType(DataTypeCode.TIMESTAMP);
            ISerializableComparable value = valueOrNull == null ? EMPTY_CELL : new DateTableCell(valueOrNull);
            this.addValue(value);
        }

        @Override
        public void addEntityLink(IEntityInformationHolderWithIdentifier entity, String linkText) {
            assert (entity != null);
            this.header.setEntityKind(entity.getEntityKind());
            EntityTableCell cell = new EntityTableCell(entity.getEntityKind(), entity.getPermId(), entity.getIdentifier());
            cell.setInvalid(DeletionUtils.isDeleted(entity));
            cell.setLinkText(linkText);
            this.addValue(cell);
        }

        @Override
        public void addEntityLink(Collection<? extends IEntityInformationHolderWithIdentifier> entities) {
            if (entities != null && !entities.isEmpty()) {
                IEntityInformationHolderWithIdentifier firstEntity = entities.iterator().next();
                if (entities.size() == 1) {
                    this.addEntityLink(firstEntity, firstEntity.getIdentifier());
                } else {
                    StringBuilder builder = new StringBuilder();
                    int counter = 0;
                    for (IEntityInformationHolderWithIdentifier iEntityInformationHolderWithIdentifier : entities) {
                        if (counter == 4) {
                            builder.append("... (").append(entities.size() - 4).append(" more)");
                            break;
                        }
                        builder.append(iEntityInformationHolderWithIdentifier.getIdentifier()).append("\n");
                        ++counter;
                    }
                    EntityTableCell entityTableCell = new EntityTableCell(firstEntity.getEntityKind(), builder.toString());
                    entityTableCell.setFake(true);
                    this.addValue(entityTableCell);
                }
            }
        }

        private void setDataType(DataTypeCode dataType) {
            this.header.setDataType(DataTypeUtils.getCompatibleDataType(this.header.getDataType(), dataType));
        }

        @Override
        public void addPerson(Person personOrNull) {
            this.addString(SimplePersonRenderer.createPersonName(personOrNull).toString());
        }

        @Override
        public void setVocabulary(Vocabulary vocabularyOrNull) {
            this.header.setVocabulary(vocabularyOrNull);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ColumnGroup
    implements IColumnGroup,
    IColumnItem {
        private final String groupKey;
        private final Set<Column> cols = new LinkedHashSet<Column>();
        private boolean uneditablePropertyColumns;

        private ColumnGroup(String groupKey) {
            this.groupKey = groupKey;
        }

        @Override
        public List<Column> getColumns() {
            return new ArrayList<Column>(this.cols);
        }

        @Override
        public IColumn column(String id) {
            Column column = TypedTableModelBuilder.this.getOrCreateColumn(id);
            this.cols.add(column);
            return column;
        }

        @Override
        public IColumnGroup uneditablePropertyColumns() {
            this.uneditablePropertyColumns = true;
            return this;
        }

        @Override
        public void addColumnsForAssignedProperties(EntityType entityType) {
            this.addColumnsForAssignedProperties(this.groupKey, entityType);
        }

        @Override
        public void addColumnsForAssignedProperties(String idPrefix, EntityType entityType) {
            List<EntityTypePropertyType<?>> propertyTypes = entityType.getAssignedPropertyTypes();
            if (propertyTypes != null) {
                for (EntityTypePropertyType<?> propertyType : propertyTypes) {
                    IColumn column = this.addColumn(idPrefix, propertyType.getPropertyType());
                    column.property(entityType.getCode(), Boolean.TRUE.toString());
                    this.setEditableFlag(column, propertyType.getPropertyType());
                    this.setVocabulary(column, propertyType.getPropertyType().getVocabulary());
                }
            }
        }

        @Override
        public void addColumnsForPropertyTypes(List<PropertyType> propertyTypes) {
            this.addColumnsForPropertyTypes(this.groupKey, propertyTypes);
        }

        @Override
        public void addColumnsForPropertyTypes(String idPrefix, List<PropertyType> propertyTypes) {
            for (PropertyType propertyType : propertyTypes) {
                this.addColumn(idPrefix, propertyType);
            }
        }

        private IColumn addColumn(String idPrefix, PropertyType propertyType) {
            String label = propertyType.getLabel();
            String code = String.valueOf(idPrefix) + TableCellUtil.getPropertyTypeCode(propertyType);
            DataTypeCode dataType = propertyType.getDataType().getCode();
            IColumn column = this.column(code).withTitle(label).withDataType(dataType);
            return column;
        }

        @Override
        public void addProperties(Collection<IEntityProperty> properties) {
            this.addProperties(this.groupKey, properties);
        }

        @Override
        public void addProperties(String idPrefix, Collection<IEntityProperty> properties) {
            for (IEntityProperty property : properties) {
                ISerializableComparable value;
                PropertyType propertyType = property.getPropertyType();
                IColumn column = this.addColumn(idPrefix, propertyType);
                DataTypeCode dataType = propertyType.getDataType().getCode();
                switch (dataType) {
                    case MATERIAL: {
                        value = new EntityTableCell(EntityKind.MATERIAL, property.getMaterial().getIdentifier());
                        break;
                    }
                    case CONTROLLEDVOCABULARY: {
                        value = new VocabularyTermTableCell(property.getVocabularyTerm());
                        break;
                    }
                    default: {
                        value = DataTypeUtils.convertTo(dataType, property.tryGetAsString());
                    }
                }
                this.setEditableFlag(column, propertyType);
                column.addValue(value);
            }
        }

        private void setEditableFlag(IColumn column, PropertyType propertyType) {
            if (this.uneditablePropertyColumns) {
                return;
            }
            if (TableCellUtil.isEditiableProperty(propertyType)) {
                column.editable();
            }
        }

        private void setVocabulary(IColumn column, Vocabulary vocabularyOrNull) {
            column.setVocabulary(vocabularyOrNull);
        }
    }

    private static final class ColumnMetaData
    implements IColumnMetaData {
        private final Column column;

        ColumnMetaData(Column column) {
            this.column = column;
        }

        public IColumnMetaData withTitle(String title) {
            this.column.getHeader().setTitle(title);
            return this;
        }

        public IColumnMetaData withDefaultWidth(int width) {
            this.column.getHeader().setDefaultColumnWidth(width);
            return this;
        }

        public IColumnMetaData withDataType(DataTypeCode dataType) {
            this.column.getHeader().setDataType(dataType);
            return this;
        }

        public IColumnMetaData hideByDefault() {
            this.column.getHeader().setHidden(true);
            return this;
        }

        public IColumnMetaData editable() {
            this.column.getHeader().setEditable(true);
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface IColumnItem {
        public List<Column> getColumns();
    }

    private static interface IIndexProvider {
        public int getIndex();
    }
}

