/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.compression.file;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.compression.file.FailureRecord;
import ch.systemsx.cisd.common.compression.file.ICompressionMethod;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.StatusFlag;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.io.File;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
class CompressionWorker
implements Runnable {
    @Private
    static final int MAX_RETRY_OF_FAILED_COMPRESSIONS = 3;
    @Private
    static final String COMPRESSING_MSG_TEMPLATE = "Compressing '%s'.";
    @Private
    static final String EXCEPTION_COMPRESSING_MSG_TEMPLATE = "Exceptional condition when trying to compress '%s'.";
    @Private
    static final String INTERRPTED_MSG = "Thread has been interrupted - exiting worker.";
    @Private
    static final String EXITING_MSG = "No more files to compress - exiting worker.";
    @Private
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, CompressionWorker.class);
    private final Queue<File> workerQueue;
    private final Collection<FailureRecord> failures;
    private final ICompressionMethod compressor;
    private final AtomicInteger activeWorkers;

    CompressionWorker(Queue<File> incommingQueue, Collection<FailureRecord> failures, ICompressionMethod compressor, AtomicInteger activeWorkers) {
        assert (incommingQueue != null);
        assert (failures != null);
        assert (compressor != null);
        assert (activeWorkers != null);
        assert (activeWorkers.get() > 0);
        this.workerQueue = incommingQueue;
        this.failures = failures;
        this.compressor = compressor;
        this.activeWorkers = activeWorkers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        while (true) {
            File fileToCompressOrNull;
            block22: {
                block23: {
                    block20: {
                        block21: {
                            if (!Thread.interrupted()) break block20;
                            if (operationLog.isInfoEnabled()) {
                                operationLog.info((Object)INTERRPTED_MSG);
                            }
                            if (this.activeWorkers.decrementAndGet() != 0) break block21;
                            Collection<FailureRecord> collection = this.failures;
                            synchronized (collection) {
                                this.failures.notify();
                            }
                        }
                        return;
                    }
                    fileToCompressOrNull = this.workerQueue.poll();
                    if (fileToCompressOrNull != null) break block22;
                    operationLog.info((Object)EXITING_MSG);
                    if (this.activeWorkers.decrementAndGet() != 0) break block23;
                    Collection<FailureRecord> collection = this.failures;
                    synchronized (collection) {
                        this.failures.notify();
                    }
                }
                return;
            }
            if (operationLog.isDebugEnabled()) {
                operationLog.debug((Object)String.format(COMPRESSING_MSG_TEMPLATE, fileToCompressOrNull));
            }
            Status status = null;
            int count = 0;
            do {
                try {
                    status = this.compressor.compress(fileToCompressOrNull);
                }
                catch (Throwable th) {
                    operationLog.error((Object)String.format(EXCEPTION_COMPRESSING_MSG_TEMPLATE, fileToCompressOrNull), th);
                    this.failures.add(new FailureRecord(fileToCompressOrNull, th));
                    status = null;
                    break;
                }
            } while (StatusFlag.RETRIABLE_ERROR.equals((Object)status.getFlag()) && ++count < 3);
            if (status == null || Status.OK.equals(status)) continue;
            this.failures.add(new FailureRecord(fileToCompressOrNull, status));
            continue;
            break;
        }
        catch (Throwable throwable) {
            if (this.activeWorkers.decrementAndGet() == 0) {
                Collection<FailureRecord> collection = this.failures;
                synchronized (collection) {
                    this.failures.notify();
                }
            }
            throw throwable;
        }
    }
}

