/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.compression.file;

import ch.systemsx.cisd.common.compression.file.ICompressionMethod;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.utilities.ISelfTestable;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class InPlaceCompressionMethod
implements ICompressionMethod,
ISelfTestable {
    private static final String INPROGRESS_MARKER = ".COMPRESSION_IN_PROGRESS_";
    private static final String COMPRESSED_MARKER = ".COMPRESSED_";
    protected static final Logger machineLog = LogFactory.getLogger(LogCategory.MACHINE, InPlaceCompressionMethod.class);
    protected static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, InPlaceCompressionMethod.class);

    private File prefixInProgress(File file) {
        assert (file != null);
        return new File(file.getParent(), INPROGRESS_MARKER + file.getName());
    }

    private File prefixCompressed(File file) {
        assert (file != null);
        return new File(file.getParent(), COMPRESSED_MARKER + file.getName());
    }

    private File tryRemovePrefix(File file) {
        assert (file != null);
        String name = file.getName();
        if (name.startsWith(INPROGRESS_MARKER)) {
            return new File(file.getParent(), name.substring(INPROGRESS_MARKER.length()));
        }
        if (name.startsWith(COMPRESSED_MARKER)) {
            return new File(file.getParent(), name.substring(COMPRESSED_MARKER.length()));
        }
        return null;
    }

    private boolean isCompressedFile(File fileToCompress) {
        return fileToCompress.getName().startsWith(COMPRESSED_MARKER);
    }

    private boolean isInProgressFile(File fileToCompress) {
        return fileToCompress.getName().startsWith(INPROGRESS_MARKER);
    }

    private Status createStatusAndLog(String msgTemplate, Object ... params) {
        String msg = String.format(msgTemplate, params);
        operationLog.error((Object)msg);
        return Status.createError(msg);
    }

    protected abstract List<String> createCommandLine(File var1, File var2);

    protected abstract List<String> getAcceptedExtensions();

    @Override
    public abstract void check() throws EnvironmentFailureException, ConfigurationFailureException;

    @Override
    public boolean accept(File pathname) {
        if (!pathname.isFile()) {
            return false;
        }
        String name = pathname.getName().toLowerCase();
        for (String extension : this.getAcceptedExtensions()) {
            if (!name.endsWith(extension)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Status compress(File fileToCompress) {
        assert (fileToCompress != null);
        if (this.isInProgressFile(fileToCompress)) {
            boolean ok = fileToCompress.delete();
            if (ok) {
                operationLog.warn((Object)String.format("Clean up: deleting left-over file '%s'", fileToCompress.getAbsolutePath()));
                return Status.OK;
            }
            return this.createStatusAndLog("Clean up: Unable to delete left-over file '%s'", fileToCompress.getAbsolutePath());
        }
        if (this.isCompressedFile(fileToCompress)) {
            boolean ok;
            File originalFile = this.tryRemovePrefix(fileToCompress);
            assert (originalFile != null);
            if (originalFile.exists() && !(ok = originalFile.delete())) {
                return this.createStatusAndLog("Clean up: Unable to delete uncompressed file '%s'", originalFile);
            }
            if (fileToCompress.renameTo(originalFile)) {
                return Status.OK;
            }
            return this.createStatusAndLog("Renaming compressed file '%s' to original name '%s' failed.", fileToCompress, originalFile);
        }
        File inProgressFile = this.prefixInProgress(fileToCompress);
        File compressionFinishedFile = this.prefixCompressed(fileToCompress);
        boolean runOK = ProcessExecutionHelper.runAndLog(this.createCommandLine(fileToCompress, inProgressFile), operationLog, machineLog);
        if (!runOK) {
            return this.createStatusAndLog("Unable to compress '%s'.", fileToCompress.getAbsolutePath());
        }
        boolean firstRenameOK = inProgressFile.renameTo(compressionFinishedFile);
        if (!firstRenameOK) {
            return this.createStatusAndLog("Unable to rename '%s' to '%s'.", inProgressFile.getAbsolutePath(), compressionFinishedFile.getAbsolutePath());
        }
        boolean removalOfOriginalOK = fileToCompress.delete();
        if (!removalOfOriginalOK) {
            return this.createStatusAndLog("Unable to delete original file '%s'", fileToCompress.getAbsolutePath());
        }
        boolean secondRenameOK = compressionFinishedFile.renameTo(fileToCompress);
        if (!secondRenameOK) {
            return this.createStatusAndLog("Unable to rename '%s' to '%s'.", compressionFinishedFile.getAbsolutePath(), fileToCompress.getAbsolutePath());
        }
        return Status.OK;
    }
}

