/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.concurrent;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.common.concurrent.FailureRecord;
import ch.systemsx.cisd.common.concurrent.ITaskExecutor;
import ch.systemsx.cisd.common.concurrent.ParallelizedWorker;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParallelizedExecutor {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, ParallelizedExecutor.class);
    private static final int NUMBER_OF_CPU_CORES = Runtime.getRuntime().availableProcessors();

    private static <T> Queue<T> tryFillWorkerQueue(List<T> itemsToProcessOrNull) throws EnvironmentFailureException {
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("Found %d files to process.", itemsToProcessOrNull.size()));
        }
        if (itemsToProcessOrNull.isEmpty()) {
            return null;
        }
        return new ArrayBlockingQueue<T>(itemsToProcessOrNull.size(), false, itemsToProcessOrNull);
    }

    @Private
    static int getInitialNumberOfWorkers(double machineLoad, int maxThreads, int numberOfTaskItems) {
        long threads = Math.round((double)NUMBER_OF_CPU_CORES * machineLoad);
        threads = Math.min(threads, (long)maxThreads);
        threads = Math.min(threads, (long)numberOfTaskItems);
        return (int)Math.max(1L, threads);
    }

    private static <T> void startUpWorkerThreads(AtomicInteger workersCounter, Queue<T> workerQueue, Collection<FailureRecord<T>> failed, ITaskExecutor<T> taskExecutor, int retriesNumberWhenExecutionFails, boolean stopOnFirstFailure) {
        int counter = workersCounter.get();
        int i = 0;
        while (i < counter) {
            ParallelizedWorker<T> worker = new ParallelizedWorker<T>(workerQueue, failed, taskExecutor, workersCounter, retriesNumberWhenExecutionFails, stopOnFirstFailure);
            new Thread(worker, "Worker " + i).start();
            ++i;
        }
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("Started up %d worker threads.", counter));
        }
    }

    public static <T> Collection<FailureRecord<T>> process(List<T> itemsToProcessOrNull, ITaskExecutor<T> taskExecutor, double machineLoad, int maxThreads, String processDescription, int retriesNumberWhenExecutionFails, boolean stopOnFirstFailure) throws InterruptedExceptionUnchecked, EnvironmentFailureException {
        long start = System.currentTimeMillis();
        Queue<T> workerQueue = ParallelizedExecutor.tryFillWorkerQueue(itemsToProcessOrNull);
        Collection<FailureRecord<T>> failed = Collections.synchronizedCollection(new ArrayList());
        if (workerQueue == null || workerQueue.isEmpty()) {
            return failed;
        }
        int numberOfWorkers = ParallelizedExecutor.getInitialNumberOfWorkers(machineLoad, maxThreads, itemsToProcessOrNull.size());
        if (numberOfWorkers == 1) {
            ParallelizedExecutor.processInTheSameThread(itemsToProcessOrNull, taskExecutor, retriesNumberWhenExecutionFails);
        } else {
            ParallelizedExecutor.processinParallel(taskExecutor, retriesNumberWhenExecutionFails, workerQueue, failed, numberOfWorkers, stopOnFirstFailure);
        }
        ParallelizedExecutor.logFinished(failed, processDescription, start);
        return failed;
    }

    private static <T> void processInTheSameThread(List<T> itemsToProcess, ITaskExecutor<T> taskExecutor, int retriesNumberWhenExecutionFails) {
        for (T item : itemsToProcess) {
            Status status;
            int counter = retriesNumberWhenExecutionFails;
            do {
                status = taskExecutor.execute(item);
            } while (--counter > 0 && status.isError());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void processinParallel(ITaskExecutor<T> taskExecutor, int retriesNumberWhenExecutionFails, Queue<T> workerQueue, Collection<FailureRecord<T>> failed, int numberOfWorkers, boolean stopOnFirstFailure) {
        AtomicInteger workersCounter = new AtomicInteger(numberOfWorkers);
        ParallelizedExecutor.startUpWorkerThreads(workersCounter, workerQueue, failed, taskExecutor, retriesNumberWhenExecutionFails, stopOnFirstFailure);
        Collection<FailureRecord<T>> collection = failed;
        synchronized (collection) {
            while (workersCounter.get() > 0) {
                try {
                    failed.wait();
                }
                catch (InterruptedException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
                }
            }
        }
    }

    private static <T> void logFinished(Collection<FailureRecord<T>> failureReport, String processDescription, long startTimeMsec) {
        int errorsNumber = failureReport.size();
        String time = "[" + (System.currentTimeMillis() - startTimeMsec) + " msec.] ";
        operationLog.info((Object)(String.valueOf(processDescription) + " finished " + (errorsNumber == 0 ? "successfully" : "with " + errorsNumber + " errors") + " " + time + "."));
    }

    public static <T> String tryFailuresToString(Collection<FailureRecord<T>> failureRecords) {
        assert (failureRecords != null);
        if (failureRecords.size() > 0) {
            StringBuilder errorMsgBuilder = new StringBuilder();
            errorMsgBuilder.append("The following items could not be successfully processed:\n");
            for (FailureRecord<T> r : failureRecords) {
                errorMsgBuilder.append(String.format("%s (%s)\n", r.getFailedItem().toString(), r.getFailureStatus()));
            }
            return errorMsgBuilder.toString();
        }
        return null;
    }

    private ParallelizedExecutor() {
    }
}

