/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.highwatermark;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.filesystem.HostAwareFile;
import ch.systemsx.cisd.common.highwatermark.HighwaterMarkWatcher;
import ch.systemsx.cisd.common.utilities.PropertyUtils;
import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.lang.StringUtils;

public final class HostAwareFileWithHighwaterMark
extends HostAwareFile {
    private static final long serialVersionUID = 1L;
    static final String SEP = "-";
    public static final int DEFAULT_HIGHWATER_MARK = -1;
    public static final String HIGHWATER_MARK_PROPERTY_KEY = "highwater-mark";
    private final long highwaterMarkInKb;

    public HostAwareFileWithHighwaterMark(String hostOrNull, File file, String rsyncModuleOrNull, long highwaterMarkInKb) {
        super(hostOrNull, file, rsyncModuleOrNull);
        this.highwaterMarkInKb = highwaterMarkInKb;
    }

    public HostAwareFileWithHighwaterMark(File path, long highwaterMarkInKb) {
        this(null, path, null, highwaterMarkInKb);
    }

    public HostAwareFileWithHighwaterMark(File path) {
        this(path, -1L);
    }

    public HostAwareFileWithHighwaterMark(String hostOrNull, File path, String rsyncModuleOrNull) {
        this(hostOrNull, path, rsyncModuleOrNull, -1L);
    }

    public static final HostAwareFileWithHighwaterMark fromProperties(Properties properties, String hostFilePropertyKey) throws ConfigurationFailureException {
        assert (properties != null) : "Unspecified properties";
        assert (StringUtils.isNotBlank((String)hostFilePropertyKey)) : "Host-file property key is blank";
        String hostFile = PropertyUtils.getMandatoryProperty(properties, hostFilePropertyKey);
        long highwaterMarkInKb = PropertyUtils.getLong(properties, hostFilePropertyKey.concat(SEP).concat(HIGHWATER_MARK_PROPERTY_KEY), -1L);
        return HostAwareFileWithHighwaterMark.create(hostFile, highwaterMarkInKb);
    }

    public static HostAwareFileWithHighwaterMark create(String hostFile, long highwaterMarkInKb) {
        File file;
        String rsyncModuleOrNull;
        String hostNameOrNull = null;
        int index = hostFile.indexOf(58);
        if (index > -1 && !HostAwareFileWithHighwaterMark.isWindowsDriveLetter(hostFile, index)) {
            hostNameOrNull = hostFile.substring(0, index);
            int index2 = hostFile.indexOf(58, index + 1);
            if (index2 > -1) {
                rsyncModuleOrNull = hostFile.substring(index + 1, index2);
                file = new File(hostFile.substring(index2 + 1));
            } else {
                rsyncModuleOrNull = null;
                file = new File(hostFile.substring(index + 1));
            }
        } else {
            rsyncModuleOrNull = null;
            file = HostAwareFileWithHighwaterMark.getCanonicalFile(hostFile);
        }
        return new HostAwareFileWithHighwaterMark(hostNameOrNull, file, rsyncModuleOrNull, highwaterMarkInKb);
    }

    private static boolean isWindowsDriveLetter(String hostFile, int colonIndex) {
        return colonIndex == 1 && hostFile.length() >= 3 && hostFile.charAt(2) == '\\';
    }

    private static File getCanonicalFile(String hostFile) {
        File file = new File(hostFile);
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            throw new ConfigurationFailureException("Unknown file " + file.getAbsolutePath());
        }
    }

    public final long getHighwaterMark() {
        return this.highwaterMarkInKb;
    }

    public final String toString() {
        StringBuilder builder = new StringBuilder(this.getCanonicalPath());
        builder.append(" ").append(String.format("[high water mark: %s]", HighwaterMarkWatcher.displayKilobyteValue(this.getHighwaterMark())));
        return builder.toString();
    }
}

