/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.io;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.base.io.RandomAccessFileImpl;
import ch.systemsx.cisd.common.io.hierarchical_content.api.IHierarchicalContentNode;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileBasedContentNode
implements IHierarchicalContentNode {
    private final File file;

    public FileBasedContentNode(File file) {
        this.file = file;
    }

    public String tryGetName() {
        return this.file.getName();
    }

    @Override
    public boolean exists() {
        return this.file.exists();
    }

    @Override
    public InputStream getInputStream() {
        try {
            return new BufferedInputStream(new FileInputStream(this.file));
        }
        catch (FileNotFoundException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
        }
    }

    @Override
    public String getName() {
        return this.file.getName();
    }

    @Override
    public String getRelativePath() {
        return this.file.getPath();
    }

    @Override
    public String getParentRelativePath() {
        return this.file.getParent();
    }

    @Override
    public boolean isDirectory() {
        return this.file.isDirectory();
    }

    @Override
    public long getLastModified() {
        return this.file.lastModified();
    }

    @Override
    public List<IHierarchicalContentNode> getChildNodes() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getFile() throws UnsupportedOperationException {
        return this.file;
    }

    @Override
    public long getFileLength() throws UnsupportedOperationException {
        return this.file.length();
    }

    @Override
    public IRandomAccessFile getFileContent() throws UnsupportedOperationException, IOExceptionUnchecked {
        return new RandomAccessFileImpl(this.file, "r");
    }
}

