/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.shared.basic;

import ch.systemsx.cisd.common.shared.basic.utils.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AlternativesStringFilter {
    private static final String PREFIX_NOT = "!";
    private static final String PREFIX_START_ANCHOR = "^";
    private static final String SUFFIX_END_ANCHOR = "$";
    private static final String ESCAPE = "\\";
    private static final String SUFFIX_ESCAPED_END_ANCHOR = "\\$";
    private List<Matcher> alternatives = new ArrayList<Matcher>();
    private static Map<String, ComparisonKind> comparisonKindByOperator = new HashMap<String, ComparisonKind>();

    static {
        ComparisonKind[] comparisonKindArray = ComparisonKind.values();
        int n = comparisonKindArray.length;
        int n2 = 0;
        while (n2 < n) {
            ComparisonKind comparisonKind = comparisonKindArray[n2];
            comparisonKindByOperator.put(comparisonKind.operator, comparisonKind);
            ++n2;
        }
    }

    public void setFilterValue(String value) {
        this.alternatives.clear();
        boolean conjunct = false;
        for (String s : StringUtils.tokenize(value)) {
            Matcher matcher;
            if (s.equals("&") && this.alternatives.size() > 0) {
                conjunct = true;
                continue;
            }
            boolean negateValue = s.startsWith(PREFIX_NOT);
            if (negateValue) {
                s = s.substring(1);
            }
            if ((matcher = this.tryGetNumericMatcher(s)) == null) {
                matcher = this.getStringMatcher(s);
            }
            if (negateValue) {
                matcher = new NegationMatcher(matcher);
            }
            if (conjunct) {
                Matcher previousMatcher = this.alternatives.remove(this.alternatives.size() - 1);
                matcher = new ConjunctionMatcher(previousMatcher, matcher);
                conjunct = false;
            }
            this.alternatives.add(matcher);
        }
    }

    private Matcher tryGetNumericMatcher(String s) {
        if (s.length() < 2) {
            return null;
        }
        if ("<>=".indexOf(s.charAt(0)) > -1) {
            int operatorLength = s.charAt(1) == '=' ? 2 : 1;
            String operator = s.substring(0, operatorLength);
            String filterValue = s.substring(operatorLength);
            ComparisonKind comparisonKindOrNull = this.tryGetComparisonKind(operator);
            if (comparisonKindOrNull == null) {
                return null;
            }
            try {
                double dobuleValue = Double.parseDouble(filterValue);
                return new NumericMatcher(comparisonKindOrNull, dobuleValue);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }
        return null;
    }

    private ComparisonKind tryGetComparisonKind(String operator) {
        return comparisonKindByOperator.get(operator);
    }

    private Matcher getStringMatcher(String s) {
        if (this.isStartAnchored(s)) {
            if (this.isEndAnchored(s)) {
                return new EqualsMatcher(s.substring(1, s.length() - 1));
            }
            return new StartAnchorMatcher(s.substring(1));
        }
        if (this.isEndAnchored(s)) {
            return new EndAnchorMatcher(s.substring(0, s.length() - 1));
        }
        return new ContainsMatcher(s);
    }

    private boolean isStartAnchored(String s) {
        return s.startsWith(PREFIX_START_ANCHOR);
    }

    private boolean isEndAnchored(String s) {
        return s.endsWith(SUFFIX_END_ANCHOR) && !s.endsWith(SUFFIX_ESCAPED_END_ANCHOR);
    }

    public boolean passes(String value) {
        if (this.alternatives.isEmpty()) {
            return true;
        }
        for (Matcher matcher : this.alternatives) {
            if (!matcher.matches(value)) continue;
            return true;
        }
        return false;
    }

    static abstract class AbstractTextMatcher
    implements Matcher {
        protected final String filterText;

        AbstractTextMatcher(String filterText) {
            this.filterText = filterText.toLowerCase().replace(AlternativesStringFilter.ESCAPE, "");
        }

        abstract boolean doMatch(String var1);

        public boolean matches(String value) {
            return this.doMatch(value);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ComparisonKind implements NumericalComparison
    {
        LT("<"){

            public boolean matches(double value, double filterValue) {
                return value < filterValue;
            }
        }
        ,
        GT(">"){

            public boolean matches(double value, double filterValue) {
                return value > filterValue;
            }
        }
        ,
        LE("<="){

            public boolean matches(double value, double filterValue) {
                return value <= filterValue;
            }
        }
        ,
        GE(">="){

            public boolean matches(double value, double filterValue) {
                return value >= filterValue;
            }
        }
        ,
        EQ("="){

            public boolean matches(double value, double filterValue) {
                return value == filterValue;
            }
        };

        private final String operator;

        private ComparisonKind(String operator) {
            this.operator = operator;
        }

        public String getOperator() {
            return this.operator;
        }
    }

    static class ConjunctionMatcher
    implements Matcher {
        private Matcher m1;
        private Matcher m2;

        ConjunctionMatcher(Matcher m1, Matcher m2) {
            this.m1 = m1;
            this.m2 = m2;
        }

        public boolean matches(String value) {
            return this.m1.matches(value) && this.m2.matches(value);
        }
    }

    static class ContainsMatcher
    extends AbstractTextMatcher {
        ContainsMatcher(String filterText) {
            super(filterText);
        }

        protected boolean doMatch(String value) {
            return value.contains(this.filterText);
        }
    }

    static class EndAnchorMatcher
    extends AbstractTextMatcher {
        EndAnchorMatcher(String filterText) {
            super(filterText);
        }

        protected boolean doMatch(String value) {
            return value.endsWith(this.filterText);
        }
    }

    static class EqualsMatcher
    extends AbstractTextMatcher {
        EqualsMatcher(String filterText) {
            super(filterText);
        }

        protected boolean doMatch(String value) {
            return value.equals(this.filterText);
        }
    }

    static interface Matcher {
        public boolean matches(String var1);
    }

    static class NegationMatcher
    implements Matcher {
        private Matcher delegate;

        NegationMatcher(Matcher delegate) {
            this.delegate = delegate;
        }

        public boolean matches(String value) {
            return !this.delegate.matches(value);
        }
    }

    static class NumericMatcher
    implements Matcher {
        protected final double filterValue;
        private NumericalComparison comparison;

        NumericMatcher(NumericalComparison comparison, double filterValue) {
            this.filterValue = filterValue;
            this.comparison = comparison;
        }

        private boolean doMatch(double value) {
            return this.comparison.matches(value, this.filterValue);
        }

        public boolean matches(String value) {
            try {
                Double d = Double.parseDouble(value);
                return this.doMatch(d);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
    }

    static interface NumericalComparison {
        public boolean matches(double var1, double var3);
    }

    static class StartAnchorMatcher
    extends AbstractTextMatcher {
        StartAnchorMatcher(String filterText) {
            super(filterText);
        }

        protected boolean doMatch(String value) {
            return value.startsWith(this.filterText);
        }
    }
}

