/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared.utils;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.process.CallableExecutor;
import ch.systemsx.cisd.common.utilities.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.shared.IPostRegistrationDatasetHandler;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import java.io.File;
import java.io.Serializable;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDatasetDropboxHandler
implements Serializable,
IPostRegistrationDatasetHandler {
    private static final long serialVersionUID = 1L;
    private static final String COPY_RETRIES_PROPERTY_NAME = "copy-max-retries";
    private static final String COPY_FAILURE_INTERVAL_IN_SEC_PROPERTY_NAME = "copy-failure-interval";
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, AbstractDatasetDropboxHandler.class);
    private static final String DEFAULT_DATASET_CODE_SEPARATOR = ".";
    public static final String DATASET_CODE_SEPARATOR_PROPERTY = "entity-separator";
    protected final String datasetCodeSeparator;
    private final IFileOperations fileOperations;
    private final int maxRetriesOnFailure;
    private final long millisToSleepOnFailure;
    private File recentlyStoredDropboxDataset;

    protected abstract File tryGetDropboxDir(File var1, DataSetInformation var2);

    protected abstract String createDropboxDestinationFileName(DataSetInformation var1, File var2);

    public AbstractDatasetDropboxHandler(Properties properties) {
        this(properties, FileOperations.getInstance());
    }

    public AbstractDatasetDropboxHandler(Properties properties, IFileOperations fileOperations) {
        this.fileOperations = fileOperations;
        this.datasetCodeSeparator = PropertyUtils.getProperty(properties, DATASET_CODE_SEPARATOR_PROPERTY, DEFAULT_DATASET_CODE_SEPARATOR);
        this.maxRetriesOnFailure = PropertyUtils.getInt(properties, COPY_RETRIES_PROPERTY_NAME, 0);
        this.millisToSleepOnFailure = PropertyUtils.getInt(properties, COPY_FAILURE_INTERVAL_IN_SEC_PROPERTY_NAME, 0) * 1000;
    }

    protected final File tryGetDirectory(String propertyName, Properties properties) {
        String filePath = PropertyUtils.getProperty(properties, propertyName);
        if (filePath == null) {
            return null;
        }
        File file = new File(filePath);
        if (!this.fileOperations.isDirectory(file)) {
            throw ConfigurationFailureException.fromTemplate("The directory '%s' set for '%s' property does not exist.", filePath, propertyName);
        }
        return file;
    }

    public final Status handle(File originalData, DataSetInformation dataSetInformation, Map<String, String> parameterBindings) {
        File dropboxDir = this.tryGetDropboxDir(originalData, dataSetInformation);
        if (dropboxDir != null) {
            String destinationFileName = this.createDropboxDestinationFileName(dataSetInformation, originalData);
            this.copy(originalData, dropboxDir, destinationFileName);
        }
        return Status.OK;
    }

    private void copy(File originalData, File dropboxDir, String destinationFileName) {
        File destFile = new File(dropboxDir, destinationFileName);
        this.copyToDirectoryAs(originalData, dropboxDir, destinationFileName);
        this.recentlyStoredDropboxDataset = destFile;
    }

    public void copyToDirectoryAs(final File source, final File destDir, final String newName) {
        Object result = new CallableExecutor(this.maxRetriesOnFailure, this.millisToSleepOnFailure).executeCallable(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                try {
                    AbstractDatasetDropboxHandler.this.fileOperations.copyToDirectoryAs(source, destDir, newName);
                }
                catch (IOExceptionUnchecked ex) {
                    operationLog.warn((Object)(String.valueOf(AbstractDatasetDropboxHandler.this.createCopyErrorMessage(source, destDir, newName)) + ". Operation will be retried. Details: " + ex.getMessage()));
                    return null;
                }
                return Boolean.TRUE;
            }
        });
        if (result == null) {
            throw new EnvironmentFailureException(this.createCopyErrorMessage(source, destDir, newName));
        }
    }

    private String createCopyErrorMessage(File source, File destDir, String newName) {
        return String.format("Cannot copy '%s' to '%s' as '%s'.", source.getPath(), destDir.getPath(), newName);
    }

    public void undoLastOperation() {
        if (this.recentlyStoredDropboxDataset != null && this.recentlyStoredDropboxDataset.exists()) {
            this.fileOperations.deleteRecursively(this.recentlyStoredDropboxDataset);
        }
        this.recentlyStoredDropboxDataset = null;
    }
}

