/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1;

import ch.systemsx.cisd.common.api.client.IServicePinger;
import ch.systemsx.cisd.common.api.client.ServiceFinder;
import ch.systemsx.cisd.openbis.generic.shared.IETLLIMSService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenBisServiceFactory {
    private final String initialServerUrl;
    private final String urlServiceSuffix;

    public OpenBisServiceFactory(String serverUrl, String urlServiceSuffix) {
        this.initialServerUrl = serverUrl;
        this.urlServiceSuffix = urlServiceSuffix;
    }

    public IETLLIMSService createService() {
        return this.createServiceFinder().createService(IETLLIMSService.class, this.initialServerUrl, this.createServicePinger());
    }

    public IETLLIMSService createService(long timeoutInMillis) {
        return this.createServiceFinder().createService(IETLLIMSService.class, this.initialServerUrl, this.createServicePinger(), timeoutInMillis);
    }

    private ServiceFinder createServiceFinder() {
        return new ServiceFinder("openbis", this.urlServiceSuffix);
    }

    private IServicePinger<IETLLIMSService> createServicePinger() {
        return new IServicePinger<IETLLIMSService>(){

            @Override
            public void ping(IETLLIMSService service) {
                service.getVersion();
            }
        };
    }
}

