/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.api.v1.dto;

import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.EntityRegistrationDetails;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.api.v1.dto.MaterialTypeIdentifier;
import java.util.Collections;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Material
extends MaterialIdentifier {
    private static final long serialVersionUID = 1L;
    private Map<String, String> properties;
    private Map<String, Material> materialProperties;
    private EntityRegistrationDetails registrationDetails;

    public Material(MaterialInitializer initializer) {
        super(initializer.getMaterialTypeIdentifier(), initializer.getMaterialCode());
        this.properties = initializer.getProperties();
        this.materialProperties = initializer.getMaterialProperties();
        this.registrationDetails = initializer.getRegistrationDetails();
    }

    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public Map<String, Material> getMaterialProperties() {
        return Collections.unmodifiableMap(this.materialProperties);
    }

    public EntityRegistrationDetails getRegistrationDetails() {
        return this.registrationDetails;
    }

    private Material() {
        super(null, null);
    }

    private void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    private void setMaterialProperties(Map<String, Material> materialProperties) {
        this.materialProperties = materialProperties;
    }

    private void setRegistrationDetails(EntityRegistrationDetails registrationDetails) {
        this.registrationDetails = registrationDetails;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class MaterialInitializer {
        private MaterialTypeIdentifier materialTypeIdentifier;
        private String materialCode;
        private Map<String, String> properties;
        private Map<String, Material> materialProperties;
        private EntityRegistrationDetails registrationDetails;

        public MaterialTypeIdentifier getMaterialTypeIdentifier() {
            return this.materialTypeIdentifier;
        }

        public void setMaterialTypeIdentifier(MaterialTypeIdentifier materialTypeIdentifier) {
            this.materialTypeIdentifier = materialTypeIdentifier;
        }

        public String getMaterialCode() {
            return this.materialCode;
        }

        public void setMaterialCode(String materialCode) {
            this.materialCode = materialCode;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public void setProperties(Map<String, String> properties) {
            this.properties = properties;
        }

        public Map<String, Material> getMaterialProperties() {
            return this.materialProperties;
        }

        public void setMaterialProperties(Map<String, Material> materialProperties) {
            this.materialProperties = materialProperties;
        }

        public EntityRegistrationDetails getRegistrationDetails() {
            return this.registrationDetails;
        }

        public void setRegistrationDetails(EntityRegistrationDetails registrationDetails) {
            this.registrationDetails = registrationDetails;
        }
    }
}

