/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.shared.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.shared.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.ExistingSpaceIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.ExperimentUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.NewExperimentPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.NewSamplePredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.SampleOwnerIdentifierPredicate;
import ch.systemsx.cisd.openbis.generic.shared.authorization.predicate.SampleUpdatesPredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewExperiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.dto.AtomicEntityOperationDetails;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewExternalData;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleUpdatesDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicOperationsPredicate
extends AbstractPredicate<AtomicEntityOperationDetails> {
    private final NewExperimentPredicate newExperimentPredicate = new NewExperimentPredicate();
    private final ExperimentUpdatesPredicate experimentUpdatesPredicate = new ExperimentUpdatesPredicate();
    private final NewSamplePredicate newSamplePredicate = new NewSamplePredicate();
    private final SampleUpdatesPredicate sampleUpdatesPredicate = new SampleUpdatesPredicate();
    private final SampleOwnerIdentifierPredicate sampleOwnerIdentifierPredicate = new SampleOwnerIdentifierPredicate(true, true);
    private final ExistingSpaceIdentifierPredicate experimentOwnerIdentifierPredicate = new ExistingSpaceIdentifierPredicate();

    @Override
    public void init(IAuthorizationDataProvider provider) {
        this.newExperimentPredicate.init(provider);
        this.experimentUpdatesPredicate.init(provider);
        this.newSamplePredicate.init(provider);
        this.sampleUpdatesPredicate.init(provider);
        this.sampleOwnerIdentifierPredicate.init(provider);
        this.experimentOwnerIdentifierPredicate.init(provider);
    }

    @Override
    public String getCandidateDescription() {
        return "atomic entity operations";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, AtomicEntityOperationDetails value) {
        AtomicOperationsPredicateEvaluator evaluator = new AtomicOperationsPredicateEvaluator(this, person, allowedRoles, value);
        return evaluator.evaluate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AtomicOperationsPredicateEvaluator {
        private final AtomicOperationsPredicate predicate;
        private final PersonPE person;
        private final List<RoleWithIdentifier> allowedRoles;
        private final AtomicEntityOperationDetails value;
        private Status result = Status.OK;

        public AtomicOperationsPredicateEvaluator(AtomicOperationsPredicate predicate, PersonPE person, List<RoleWithIdentifier> allowedRoles, AtomicEntityOperationDetails value) {
            this.predicate = predicate;
            this.person = person;
            this.allowedRoles = allowedRoles;
            this.value = value;
        }

        public Status evaluate() {
            if (this.result.equals(Status.OK)) {
                this.result = this.evaluateExperimentUpdatePredicate();
            }
            if (this.result.equals(Status.OK)) {
                this.result = this.evaluateNewExperimentPredicate();
            }
            if (this.result.equals(Status.OK)) {
                this.result = this.evaluateSampleUpdatePredicate();
            }
            if (this.result.equals(Status.OK)) {
                this.result = this.evaluateNewSamplePredicate();
            }
            if (this.result.equals(Status.OK)) {
                this.result = this.evaluateDataSetRegistrationsPredicate();
            }
            if (this.result.equals(Status.OK)) {
                this.result = this.evaluateDataSetUpdatesPredicate();
            }
            return this.result;
        }

        private Status evaluateExperimentUpdatePredicate() {
            for (ExperimentUpdatesDTO experimentUpdates : this.value.getExperimentUpdates()) {
                Status status = this.predicate.experimentUpdatesPredicate.doEvaluation(this.person, this.allowedRoles, experimentUpdates);
                if (status.equals(Status.OK)) continue;
                return status;
            }
            return Status.OK;
        }

        private Status evaluateNewExperimentPredicate() {
            for (NewExperiment newExperiment : this.value.getExperimentRegistrations()) {
                Status status = this.predicate.newExperimentPredicate.doEvaluation(this.person, this.allowedRoles, newExperiment);
                if (status.equals(Status.OK)) continue;
                return status;
            }
            return Status.OK;
        }

        private Status evaluateSampleUpdatePredicate() {
            for (SampleUpdatesDTO sampleUpdates : this.value.getSampleUpdates()) {
                Status status = this.predicate.sampleUpdatesPredicate.doEvaluation(this.person, this.allowedRoles, sampleUpdates);
                if (status.equals(Status.OK)) continue;
                return status;
            }
            return Status.OK;
        }

        private Status evaluateNewSamplePredicate() {
            for (NewSample newSample : this.value.getSampleRegistrations()) {
                Status status = this.predicate.newSamplePredicate.doEvaluation(this.person, this.allowedRoles, newSample);
                if (status.equals(Status.OK)) continue;
                return status;
            }
            return Status.OK;
        }

        private Status evaluateDataSetRegistrationsPredicate() {
            for (NewExternalData newExternalData : this.value.getDataSetRegistrations()) {
                Status status = this.evaluateDataSetPredicate(newExternalData.getSampleIdentifierOrNull(), newExternalData.getExperimentIdentifierOrNull());
                if (status.equals(Status.OK)) continue;
                return status;
            }
            return Status.OK;
        }

        private Status evaluateDataSetUpdatesPredicate() {
            for (DataSetUpdatesDTO dataSetUpdate : this.value.getDataSetUpdates()) {
                Status status = this.evaluateDataSetPredicate(dataSetUpdate.getSampleIdentifierOrNull(), dataSetUpdate.getExperimentIdentifierOrNull());
                if (status.equals(Status.OK)) continue;
                return status;
            }
            return Status.OK;
        }

        private Status evaluateDataSetPredicate(SampleIdentifier sampleIdentifier, ExperimentIdentifier experimentIdentifier) {
            Status status = sampleIdentifier != null ? this.predicate.sampleOwnerIdentifierPredicate.doEvaluation(this.person, this.allowedRoles, sampleIdentifier) : this.predicate.experimentOwnerIdentifierPredicate.doEvaluation(this.person, this.allowedRoles, experimentIdentifier);
            return status;
        }
    }
}

