/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.systemsx.cisd.openbis.generic.shared.basic.IIdHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.MappedSuperclass;
import javax.persistence.Version;
import org.hibernate.validator.Length;
import org.hibernate.validator.NotNull;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@MappedSuperclass
public abstract class AbstractExpressionPE<T>
extends HibernateAbstractRegistrationHolder
implements IIdHolder,
Comparable<T>,
Serializable {
    private static final long serialVersionUID = 32L;
    private String description;
    private String expression;
    private boolean isPublic;
    private Date modificationDate;
    private DatabaseInstancePE databaseInstance;
    protected Long id;

    @Column(name="description")
    @Length(max=2000, message="Given description '%s' is too long (maximal length: {max} characters).")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="expression")
    @NotNull(message="Expression can not be null.")
    @Length(min=1, message="Given expression '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    public String getExpression() {
        return this.expression;
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    @Column(name="is_public")
    public boolean isPublic() {
        return this.isPublic;
    }

    public void setPublic(boolean isPublic) {
        this.isPublic = isPublic;
    }

    @Version
    @Column(name="modification_timestamp", nullable=false)
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date versionDate) {
        this.modificationDate = versionDate;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Database instance can not be null.")
    @JoinColumn(name="dbin_id", updatable=false)
    public DatabaseInstancePE getDatabaseInstance() {
        return this.databaseInstance;
    }

    public void setDatabaseInstance(DatabaseInstancePE databaseInstance) {
        this.databaseInstance = databaseInstance;
    }

    public final void setId(Long id) {
        this.id = id;
    }
}

