/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.dto;

import ch.rinn.restrictions.Friend;
import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.collections.UnmodifiableListDecorator;
import ch.systemsx.cisd.common.collections.UnmodifiableSetDecorator;
import ch.systemsx.cisd.common.utilities.ModifiedShortPrefixToStringStyle;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AttachmentHolderKind;
import ch.systemsx.cisd.openbis.generic.shared.dto.AbstractIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletionPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPropertyPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.HibernateAbstractRegistrationHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IDeletablePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.dto.IMatchingEntity;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.IdentifierHelper;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.util.EqualsHashUtils;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.persistence.Version;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Fetch;
import org.hibernate.annotations.FetchMode;
import org.hibernate.annotations.Generated;
import org.hibernate.annotations.GenerationTime;
import org.hibernate.search.annotations.DocumentId;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.Index;
import org.hibernate.search.annotations.Indexed;
import org.hibernate.search.annotations.IndexedEmbedded;
import org.hibernate.search.annotations.Store;
import org.hibernate.validator.Length;
import org.hibernate.validator.NotNull;
import org.hibernate.validator.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="experiments", uniqueConstraints={@UniqueConstraint(columnNames={"code", "proj_id"})})
@Indexed(index="ExperimentPE")
@Friend(toClasses={AttachmentPE.class, ProjectPE.class})
public class ExperimentPE
extends AttachmentHolderPE
implements IEntityInformationWithPropertiesHolder,
IIdAndCodeHolder,
Comparable<ExperimentPE>,
IMatchingEntity,
IDeletablePE,
Serializable {
    private static final long serialVersionUID = 32L;
    public static final ExperimentPE[] EMPTY_ARRAY = new ExperimentPE[0];
    private transient Long id;
    private String code;
    private ProjectPE project;
    private ExperimentTypePE experimentType;
    private DeletionPE deletion;
    private Set<ExperimentPropertyPE> properties = new HashSet<ExperimentPropertyPE>();
    private List<SamplePE> samples = new ArrayList<SamplePE>();
    private List<DataPE> dataSets = new ArrayList<DataPE>();
    private Date lastDataSetDate;
    private ExperimentIdentifier experimentIdentifier;
    private PersonPE registrator;
    private Date registrationDate;
    private Date modificationDate;
    private String permId;

    @Column(name="registration_timestamp", nullable=false, insertable=false, updatable=false)
    @Generated(value=GenerationTime.INSERT)
    public Date getRegistrationDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.registrationDate);
    }

    public void setRegistrationDate(Date registrationDate) {
        this.registrationDate = registrationDate;
    }

    @Override
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="pers_id_registerer", updatable=false)
    @IndexedEmbedded(prefix="registrator ")
    public PersonPE getRegistrator() {
        return this.registrator;
    }

    public void setRegistrator(PersonPE registrator) {
        this.registrator = registrator;
    }

    @Override
    @Id
    @SequenceGenerator(name="EXPERIMENT_ID_SEQ", sequenceName="EXPERIMENT_ID_SEQ", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="EXPERIMENT_ID_SEQ")
    @DocumentId(name="id")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    @Column(name="code")
    @Length(min=1, max=60, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @NotNull(message="Code can not be null.")
    @Pattern(regex="^[A-Z0-9_\\-\\.]+$", flags=2, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    @Field(index=Index.TOKENIZED, store=Store.YES, name="code")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Project can not be null.")
    @JoinColumn(name="proj_id", updatable=true)
    @IndexedEmbedded(prefix="project ")
    private ProjectPE getProjectInternal() {
        return this.project;
    }

    @Private
    void setProjectInternal(ProjectPE project) {
        this.project = project;
    }

    @Transient
    public ProjectPE getProject() {
        return this.getProjectInternal();
    }

    public void setProject(ProjectPE project) {
        project.addExperiment(this);
    }

    @ManyToOne(fetch=FetchType.EAGER)
    @NotNull(message="Experiment type can not be null.")
    @JoinColumn(name="exty_id", updatable=false)
    @IndexedEmbedded(prefix="type ")
    public ExperimentTypePE getExperimentType() {
        return this.experimentType;
    }

    public void setExperimentType(ExperimentTypePE experimentType) {
        this.experimentType = experimentType;
    }

    @Override
    @ManyToOne(fetch=FetchType.EAGER)
    @JoinColumn(name="del_id")
    public DeletionPE getDeletion() {
        return this.deletion;
    }

    public void setDeletion(DeletionPE deletion) {
        this.deletion = deletion;
    }

    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, mappedBy="entity")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @Cache(usage=CacheConcurrencyStrategy.READ_WRITE)
    @IndexedEmbedded(prefix="property ")
    @Fetch(value=FetchMode.SUBSELECT)
    private Set<ExperimentPropertyPE> getExperimentProperties() {
        return this.properties;
    }

    private void setExperimentProperties(Set<ExperimentPropertyPE> properties) {
        this.properties = properties;
    }

    @Transient
    public Set<ExperimentPropertyPE> getProperties() {
        return new UnmodifiableSetDecorator<ExperimentPropertyPE>(this.getExperimentProperties());
    }

    @Override
    @Transient
    public boolean isPropertiesInitialized() {
        return HibernateUtils.isInitialized(this.getExperimentProperties());
    }

    @Override
    public void setProperties(Set<? extends EntityPropertyPE> properties) {
        this.getExperimentProperties().clear();
        for (EntityPropertyPE entityPropertyPE : properties) {
            ExperimentPropertyPE experimentProperty = (ExperimentPropertyPE)entityPropertyPE;
            ExperimentPE parent = experimentProperty.getEntity();
            if (parent != null) {
                parent.getExperimentProperties().remove(experimentProperty);
            }
            this.addProperty(experimentProperty);
        }
    }

    @Override
    public void addProperty(EntityPropertyPE property) {
        property.setEntity(this);
        this.getExperimentProperties().add((ExperimentPropertyPE)property);
    }

    @Override
    public void removeProperty(EntityPropertyPE property) {
        this.getExperimentProperties().remove(property);
        property.setEntity(null);
    }

    @Override
    @OneToMany(fetch=FetchType.LAZY, mappedBy="experimentParentInternal", cascade={CascadeType.ALL})
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    @IndexedEmbedded(prefix="attachment ")
    @Fetch(value=FetchMode.SUBSELECT)
    protected Set<AttachmentPE> getInternalAttachments() {
        return this.attachments;
    }

    @Transient
    public List<SamplePE> getSamples() {
        return new UnmodifiableListDecorator<SamplePE>(this.getExperimentSamples());
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="experimentInternal")
    private List<SamplePE> getExperimentSamples() {
        return this.samples;
    }

    private void setExperimentSamples(List<SamplePE> samples) {
        this.samples = samples;
    }

    public void setSamples(List<SamplePE> samples) {
        this.getExperimentSamples().clear();
        for (SamplePE sample : samples) {
            this.addSample(sample);
        }
    }

    public void removeSample(SamplePE sample) {
        this.getExperimentSamples().remove(sample);
        sample.setExperimentInternal(null);
    }

    public void addSample(SamplePE sample) {
        ExperimentPE experiment = sample.getExperiment();
        if (experiment != null) {
            experiment.getExperimentSamples().remove(sample);
        }
        sample.setExperimentInternal(this);
        this.getExperimentSamples().add(sample);
    }

    @Transient
    public List<DataPE> getDataSets() {
        return new UnmodifiableListDecorator<DataPE>(this.getExperimentDataSets());
    }

    @OneToMany(fetch=FetchType.LAZY, mappedBy="experimentInternal")
    private List<DataPE> getExperimentDataSets() {
        return this.dataSets;
    }

    private void setExperimentDataSets(List<DataPE> dataSets) {
        this.dataSets = dataSets;
    }

    public final void setDataSets(List<DataPE> dataSets) {
        this.getExperimentDataSets().clear();
        for (DataPE child : dataSets) {
            this.addDataSet(child);
        }
    }

    public void addDataSet(DataPE child) {
        ExperimentPE parent = child.getExperiment();
        if (parent != null) {
            parent.getExperimentDataSets().remove(child);
        }
        child.setExperimentInternal(this);
        this.getExperimentDataSets().add(child);
    }

    @Transient
    public Date getLastDataSetDate() {
        return HibernateAbstractRegistrationHolder.getDate(this.lastDataSetDate);
    }

    public void setLastDataSetDate(Date lastDataSetDate) {
        this.lastDataSetDate = lastDataSetDate;
    }

    @Override
    public int compareTo(ExperimentPE o) {
        return AbstractIdAndCodeHolder.compare(this, o);
    }

    public final boolean equals(Object obj) {
        EqualsHashUtils.assertDefined(this.getCode(), "code");
        EqualsHashUtils.assertDefined(this.getProject(), "project");
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ExperimentPE)) {
            return false;
        }
        ExperimentPE that = (ExperimentPE)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append((Object)this.getCode(), (Object)that.getCode());
        builder.append((Object)this.getProject(), (Object)that.getProject());
        return builder.isEquals();
    }

    public final int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append((Object)this.getCode());
        builder.append((Object)this.getProject());
        return builder.toHashCode();
    }

    public final String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
        builder.append("code", (Object)this.getCode());
        builder.append("project", (Object)this.getProject());
        builder.append("experimentType", (Object)this.getExperimentType());
        builder.append("deletion", (Object)this.getDeletion());
        return builder.toString();
    }

    @Override
    @Transient
    @Field(index=Index.NO, store=Store.YES, name="identifier")
    public final String getIdentifier() {
        if (this.experimentIdentifier == null) {
            this.experimentIdentifier = IdentifierHelper.createExperimentIdentifier(this);
        }
        return this.experimentIdentifier.toString();
    }

    @Override
    @Transient
    public final EntityTypePE getEntityType() {
        return this.getExperimentType();
    }

    @Override
    @Transient
    public final EntityKind getEntityKind() {
        return EntityKind.EXPERIMENT;
    }

    @Version
    @Column(name="modification_timestamp", nullable=false)
    public Date getModificationDate() {
        return this.modificationDate;
    }

    public void setModificationDate(Date versionDate) {
        this.modificationDate = versionDate;
    }

    @Override
    @Transient
    public AttachmentHolderKind getAttachmentHolderKind() {
        return AttachmentHolderKind.EXPERIMENT;
    }

    @Override
    @NotNull(message="Code can not be null.")
    @Length(min=1, max=60, message="Given code '%s' is either too short (minimal length: {min} character) or too long (maximal length: {max} characters).")
    @Pattern(regex="^[A-Z0-9_\\-\\.]+$", flags=2, message="Given code '%s' contains illegal characters (allowed: A-Z, a-z, 0-9 and _, -, .)")
    @Column(name="perm_id", nullable=false)
    @Field(index=Index.NO, store=Store.YES, name="perm_id")
    public String getPermId() {
        return this.permId;
    }

    public void setPermId(String permId) {
        this.permId = permId;
    }
}

