/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.parser;

import ch.systemsx.cisd.common.parser.AbstractParserObjectFactory;
import ch.systemsx.cisd.common.parser.IPropertyMapper;
import ch.systemsx.cisd.common.parser.IPropertyModel;
import ch.systemsx.cisd.common.parser.ParserException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NewSampleParserObjectFactory
extends AbstractParserObjectFactory<NewSample> {
    private final SampleType sampleType;
    private final boolean identifierExpectedInFile;
    private final boolean allowExperiments;

    NewSampleParserObjectFactory(SampleType sampleType, IPropertyMapper propertyMapper, boolean identifierExpectedInFile, boolean allowExperiments) {
        super(NewSample.class, propertyMapper);
        this.sampleType = sampleType;
        this.identifierExpectedInFile = identifierExpectedInFile;
        this.allowExperiments = allowExperiments;
    }

    private final PropertyType createPropertyType(String propertyTypeCode) {
        PropertyType propertyType = new PropertyType();
        DataType dataType = new DataType();
        dataType.setCode(DataTypeCode.VARCHAR);
        propertyType.setCode(propertyTypeCode);
        propertyType.setDataType(dataType);
        return propertyType;
    }

    private final void setProperties(NewSample newSample, String[] lineTokens) {
        ArrayList<EntityProperty> properties = new ArrayList<EntityProperty>();
        for (String unmatchedProperty : this.getUnmatchedProperties()) {
            String propertyDefault;
            IPropertyModel propertyModel = this.tryGetPropertyModel(unmatchedProperty);
            String propertyValue = this.getPropertyValue(lineTokens, propertyModel, propertyDefault = this.tryGetPropertyDefault(unmatchedProperty));
            if (StringUtils.isEmpty((String)propertyValue)) continue;
            EntityProperty property = new EntityProperty();
            property.setPropertyType(this.createPropertyType(unmatchedProperty));
            property.setValue(propertyValue);
            properties.add(property);
        }
        newSample.setProperties(properties.toArray(IEntityProperty.EMPTY_ARRAY));
    }

    @Override
    protected final boolean ignoreUnmatchedProperties() {
        return true;
    }

    @Override
    public NewSample createObject(String[] lineTokens) throws ParserException {
        NewSample newSample = (NewSample)super.createObject(lineTokens);
        if (this.identifierExpectedInFile && newSample.getIdentifier() == null) {
            throw new ParserException("Mandatory column 'identifier' is missing.");
        }
        if (!this.identifierExpectedInFile && newSample.getIdentifier() != null) {
            throw new ParserException("Requested automatical generation of codes. Column 'identifier' should be removed from the file.");
        }
        if (!this.allowExperiments && newSample.getExperimentIdentifier() != null) {
            throw new ParserException("Column 'experiment' should be removed from the file.");
        }
        newSample.setSampleType(this.sampleType);
        this.setProperties(newSample, lineTokens);
        if (newSample.getParentsOrNull() != null) {
            ArrayList<String> parents = new ArrayList<String>();
            String[] stringArray = newSample.getParentsOrNull();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String parent = stringArray[n2];
                String trimmedOrNull = StringUtils.trimToNull((String)parent);
                if (trimmedOrNull != null) {
                    parents.add(trimmedOrNull);
                }
                ++n2;
            }
            if (parents.size() == 0) {
                newSample.setParentsOrNull(null);
            } else {
                newSample.setParentsOrNull(parents.toArray(new String[0]));
            }
        }
        newSample.setExperimentIdentifier(StringUtils.trimToNull((String)newSample.getExperimentIdentifier()));
        return newSample;
    }
}

