/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Person;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.translator.DatabaseInstanceTranslator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersonTranslator {
    private PersonTranslator() {
    }

    public static final List<Person> translate(Collection<PersonPE> persons) {
        ArrayList<Person> result = new ArrayList<Person>();
        for (PersonPE person : persons) {
            result.add(PersonTranslator.translate(person, true));
        }
        return result;
    }

    public static final Person translate(PersonPE person) {
        return PersonTranslator.translate(person, false);
    }

    private static final Person translate(PersonPE person, boolean recursively) {
        if (person == null) {
            return null;
        }
        Person result = new Person();
        result.setFirstName(person.getFirstName());
        result.setLastName(person.getLastName());
        result.setEmail(person.getEmail());
        result.setUserId(person.getUserId());
        result.setDatabaseInstance(DatabaseInstanceTranslator.translate(person.getDatabaseInstance()));
        result.setRegistrationDate(person.getRegistrationDate());
        if (recursively) {
            result.setRegistrator(PersonTranslator.translate(person.getRegistrator(), false));
        }
        return result;
    }
}

