/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.translator.DatabaseInstanceTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTypePropertyTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SampleTypeTranslator {
    private SampleTypeTranslator() {
    }

    public static SampleType translate(SampleTypePE sampleTypePE, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        SampleType result = new SampleType();
        result.setId(HibernateUtils.getId(sampleTypePE));
        result.setCode(sampleTypePE.getCode());
        result.setListable(sampleTypePE.isListable());
        result.setDescription(sampleTypePE.getDescription());
        result.setGeneratedFromHierarchyDepth(sampleTypePE.getGeneratedFromHierarchyDepth());
        result.setContainerHierarchyDepth(sampleTypePE.getContainerHierarchyDepth());
        result.setSubcodeUnique(sampleTypePE.isSubcodeUnique());
        result.setAutoGeneratedCode(sampleTypePE.isAutoGeneratedCode());
        result.setGeneratedCodePrefix(sampleTypePE.getGeneratedCodePrefix());
        result.setSampleTypePropertyTypes(EntityType.sortedInternally(SampleTypePropertyTypeTranslator.translate(sampleTypePE.getSampleTypePropertyTypes(), result, cacheOrNull)));
        result.setDatabaseInstance(DatabaseInstanceTranslator.translate(sampleTypePE.getDatabaseInstance()));
        return result;
    }

    public static List<SampleType> translate(List<SampleTypePE> sampleTypes, Map<PropertyTypePE, PropertyType> cacheOrNull) {
        ArrayList<SampleType> result = new ArrayList<SampleType>();
        for (SampleTypePE sampleTypePE : sampleTypes) {
            result.add(SampleTypeTranslator.translate(sampleTypePE, cacheOrNull));
        }
        return result;
    }

    public static SampleTypePE translate(SampleType sampleType) {
        SampleTypePE result = new SampleTypePE();
        result.setCode(sampleType.getCode());
        return result;
    }

    public static boolean getShowContainer(SampleTypePE sampleTypePE) {
        return sampleTypePE.getContainerHierarchyDepth() > 0;
    }
}

