/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.api.v1;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.io.ConcatenatedFileOutputStreamWriter;
import ch.systemsx.cisd.etlserver.ITopLevelDataSetRegistrator;
import ch.systemsx.cisd.etlserver.ITopLevelDataSetRegistratorDelegate;
import ch.systemsx.cisd.etlserver.api.v1.PutDataSetService;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationPreStagingBehavior;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.FileInfoDssDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.v1.NewDataSetDTO;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;

class PutDataSetTopLevelDataSetHandler {
    private final PutDataSetService service;
    private final ITopLevelDataSetRegistrator registrator;
    private final String sessionToken;
    private final NewDataSetDTO newDataSet;
    private final InputStream inputStream;
    private final File temporaryIncomingDir;
    private final File dataSetDir;
    private final File dataSet;

    PutDataSetTopLevelDataSetHandler(PutDataSetService service, ITopLevelDataSetRegistrator registrator, String sessionToken, NewDataSetDTO newDataSet, InputStream inputStream) {
        boolean dataSetIsASingleFile;
        this.service = service;
        this.registrator = registrator;
        this.sessionToken = sessionToken;
        this.newDataSet = newDataSet;
        this.inputStream = inputStream;
        this.temporaryIncomingDir = service.createTemporaryIncomingDir(newDataSet.tryDataSetType());
        String dataSetFolderName = newDataSet.getDataSetFolderName();
        boolean bl = dataSetIsASingleFile = NewDataSetDTO.DEFAULT_DATA_SET_FOLDER_NAME.equals(dataSetFolderName) && newDataSet.getFileInfos().size() == 1;
        if (dataSetIsASingleFile) {
            this.dataSetDir = this.temporaryIncomingDir;
            this.dataSet = new File(this.temporaryIncomingDir, newDataSet.getFileInfos().get(0).getPathInDataSet());
        } else {
            this.dataSet = this.dataSetDir = new File(this.temporaryIncomingDir, dataSetFolderName);
        }
        if (this.dataSetDir.exists()) {
            this.deleteDataSetDir();
        }
        if (!this.dataSetDir.mkdir()) {
            throw new EnvironmentFailureException("Could not create directory for data set " + this.dataSet.getName());
        }
    }

    public List<DataSetInformation> execute() throws UserFailureException, IOException {
        SpaceIdentifier spaceId = this.getSpaceIdentifierForNewDataSet();
        if (spaceId != null) {
            this.getOpenBisService().checkSpaceAccess(this.sessionToken, spaceId);
        }
        this.writeDataSetToTempDirectory();
        try {
            DataSetRegistratorDelegate delegate = new DataSetRegistratorDelegate();
            this.registrator.handle(this.dataSet, this.getCallerDataSetInformation(), delegate);
            ArrayList arrayList = delegate.registeredDataSets;
            return arrayList;
        }
        finally {
            this.deleteDataSetDir();
        }
    }

    public SessionContextDTO getSessionContext() {
        return this.getOpenBisService().tryGetSession(this.sessionToken);
    }

    public NewDataSetDTO.DataSetOwner getDataSetOwner() {
        return this.newDataSet.getDataSetOwner();
    }

    public DataSetInformation getCallerDataSetInformation() {
        Map<String, String> primitiveProps;
        String typeCode;
        DataSetInformation dataSetInfo = new DataSetInformation();
        SessionContextDTO sessionContext = this.getSessionContext();
        dataSetInfo.setUploadingUserEmail(sessionContext.getUserEmail());
        dataSetInfo.setUploadingUserId(sessionContext.getUserName());
        NewDataSetDTO.DataSetOwner owner = this.getDataSetOwner();
        if (owner != null) {
            switch (owner.getType()) {
                case EXPERIMENT: {
                    dataSetInfo.setExperimentIdentifier(this.tryExperimentIdentifier());
                    break;
                }
                case SAMPLE: {
                    SampleIdentifier sampleId = this.trySampleIdentifier();
                    dataSetInfo.setSampleCode(sampleId.getSampleCode());
                    dataSetInfo.setSpaceCode(sampleId.getSpaceLevel().getSpaceCode());
                    dataSetInfo.setInstanceCode(sampleId.getSpaceLevel().getDatabaseInstanceCode());
                    break;
                }
                case DATA_SET: {
                    String dataSetCode = this.tryGetDataSetCode();
                    AbstractExternalData parentDataSet = this.getOpenBisService().tryGetDataSet(dataSetCode);
                    if (parentDataSet == null) break;
                    if (parentDataSet.getExperiment() != null) {
                        dataSetInfo.setExperiment(parentDataSet.getExperiment());
                    }
                    if (parentDataSet.getSample() != null) {
                        dataSetInfo.setSample(parentDataSet.getSample());
                    }
                    ArrayList<String> parentDataSetCodes = new ArrayList<String>();
                    parentDataSetCodes.add(parentDataSet.getCode());
                    parentDataSetCodes.addAll(dataSetInfo.getParentDataSetCodes());
                    dataSetInfo.setParentDataSetCodes(parentDataSetCodes);
                }
            }
        }
        if ((typeCode = this.newDataSet.tryDataSetType()) != null) {
            dataSetInfo.setDataSetType(new DataSetType(typeCode));
        }
        if (!(primitiveProps = this.newDataSet.getProperties()).isEmpty()) {
            ArrayList<NewProperty> properties = new ArrayList<NewProperty>();
            for (String key : primitiveProps.keySet()) {
                properties.add(new NewProperty(key, primitiveProps.get(key)));
            }
            dataSetInfo.setDataSetProperties(properties);
        }
        ArrayList<String> parentDataSetCodes = new ArrayList<String>();
        parentDataSetCodes.addAll(dataSetInfo.getParentDataSetCodes());
        parentDataSetCodes.addAll(this.newDataSet.getParentDataSetCodes());
        dataSetInfo.setParentDataSetCodes(parentDataSetCodes);
        return dataSetInfo;
    }

    private void writeDataSetToTempDirectory() throws IOException {
        ConcatenatedFileOutputStreamWriter imagesWriter = new ConcatenatedFileOutputStreamWriter(this.inputStream);
        for (FileInfoDssDTO fileInfo : this.newDataSet.getFileInfos()) {
            if (fileInfo.isDirectory()) {
                File file = new File(this.dataSetDir, fileInfo.getPathInDataSet());
                file.mkdir();
                continue;
            }
            OutputStream output = this.getOutputStream(fileInfo);
            imagesWriter.writeNextBlock(output);
            output.flush();
            output.close();
        }
    }

    private OutputStream getOutputStream(FileInfoDssDTO fileInfo) {
        FileOutputStream fos;
        File file = new File(this.dataSetDir, fileInfo.getPathInDataSet());
        try {
            fos = new FileOutputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new EnvironmentFailureException("Could not save file " + file, ex);
        }
        return new BufferedOutputStream(fos);
    }

    private void deleteDataSetDir() {
        this.deleteDir(this.temporaryIncomingDir);
    }

    private void deleteDir(File dirToDelete) {
        try {
            FileUtils.deleteDirectory((File)dirToDelete);
        }
        catch (IOException ex) {
            this.getOperationLog().error("Could not delete data set directory " + dirToDelete, ex);
            ex.printStackTrace();
        }
    }

    private SpaceIdentifier getSpaceIdentifierForNewDataSet() {
        SpaceIdentifier spaceId = null;
        NewDataSetDTO.DataSetOwner owner = this.getDataSetOwner();
        if (owner != null) {
            switch (owner.getType()) {
                case EXPERIMENT: {
                    ExperimentIdentifier experimentId = this.tryExperimentIdentifier();
                    spaceId = new SpaceIdentifier(experimentId.getDatabaseInstanceCode(), experimentId.getSpaceCode());
                    break;
                }
                case SAMPLE: {
                    SampleIdentifier sampleId = this.trySampleIdentifier();
                    spaceId = sampleId.getSpaceLevel();
                    break;
                }
                case DATA_SET: {
                    String dataSetCode = this.tryGetDataSetCode();
                    AbstractExternalData parentDataSet = this.getOpenBisService().tryGetDataSet(dataSetCode);
                    if (parentDataSet == null) break;
                    if (parentDataSet.getExperiment() != null) {
                        ExperimentIdentifier experimentId = ExperimentIdentifierFactory.parse(parentDataSet.getExperiment().getIdentifier());
                        spaceId = new SpaceIdentifier(experimentId.getDatabaseInstanceCode(), experimentId.getSpaceCode());
                    }
                    if (parentDataSet.getSample() == null) break;
                    SampleIdentifier sampleId = SampleIdentifierFactory.parse(parentDataSet.getSample().getIdentifier());
                    spaceId = sampleId.getSpaceLevel();
                }
            }
        }
        return spaceId;
    }

    private ExperimentIdentifier tryExperimentIdentifier() {
        NewDataSetDTO.DataSetOwner owner = this.getDataSetOwner();
        switch (owner.getType()) {
            case EXPERIMENT: {
                return new ExperimentIdentifierFactory(owner.getIdentifier()).createIdentifier();
            }
        }
        return null;
    }

    private SampleIdentifier trySampleIdentifier() {
        NewDataSetDTO.DataSetOwner owner = this.getDataSetOwner();
        switch (owner.getType()) {
            case SAMPLE: {
                return new SampleIdentifierFactory(owner.getIdentifier()).createIdentifier();
            }
        }
        return null;
    }

    private String tryGetDataSetCode() {
        NewDataSetDTO.DataSetOwner owner = this.getDataSetOwner();
        switch (owner.getType()) {
            case DATA_SET: {
                return owner.getIdentifier();
            }
        }
        return null;
    }

    private IEncapsulatedOpenBISService getOpenBisService() {
        return this.service.getOpenBisService();
    }

    private Logger getOperationLog() {
        return this.service.getOperationLog();
    }

    private static class DataSetRegistratorDelegate
    implements ITopLevelDataSetRegistratorDelegate {
        private final ArrayList<DataSetInformation> registeredDataSets = new ArrayList();

        private DataSetRegistratorDelegate() {
        }

        @Override
        public void didRegisterDataSets(List<DataSetInformation> dataSetInformations) {
            this.registeredDataSets.addAll(dataSetInformations);
        }

        @Override
        public DataSetRegistrationPreStagingBehavior getPrestagingBehavior() {
            return DataSetRegistrationPreStagingBehavior.USE_ORIGINAL;
        }
    }
}

