/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.shared;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.server.ISessionTokenProvider;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.ISessionWorkspaceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.dto.OpenBISSessionHolder;
import java.io.File;
import java.util.Map;
import org.apache.log4j.Logger;

public class DataSetProcessingContext {
    static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DataSetProcessingContext.class);
    private final Map<String, String> parameterBindings;
    private final IMailClient mailClient;
    private final String userEmailOrNull;
    private final IDataSetDirectoryProvider directoryProvider;
    private final IHierarchicalContentProvider hierarchicalContentProvider;
    private final String sessionTokenOrNull;
    private final ISessionWorkspaceProvider sessionWorkspaceProviderOrNull;
    private final String userId;
    private final IEncapsulatedOpenBISService service;

    public DataSetProcessingContext(IHierarchicalContentProvider contentProvider, IDataSetDirectoryProvider directoryProvider, Map<String, String> parameterBindings, IMailClient mailClient, String userId, String userEmailOrNull) {
        this(null, contentProvider, directoryProvider, null, parameterBindings, mailClient, userId, userEmailOrNull, null);
    }

    public DataSetProcessingContext(IHierarchicalContentProvider contentProvider, IDataSetDirectoryProvider directoryProvider, Map<String, String> parameterBindings, IMailClient mailClient, String userId, String userEmailOrNull, String sessionTokenOrNull) {
        this(contentProvider, directoryProvider, null, parameterBindings, mailClient, userId, userEmailOrNull, sessionTokenOrNull);
    }

    public DataSetProcessingContext(IHierarchicalContentProvider contentProvider, IDataSetDirectoryProvider directoryProvider, ISessionWorkspaceProvider sessionWorkspaceProviderOrNull, Map<String, String> parameterBindings, IMailClient mailClient, String userId, String userEmailOrNull, String sessionTokenOrNull) {
        this(ServiceProvider.getOpenBISService(), contentProvider, directoryProvider, sessionWorkspaceProviderOrNull, parameterBindings, mailClient, userId, userEmailOrNull, sessionTokenOrNull);
    }

    private DataSetProcessingContext(IEncapsulatedOpenBISService service, IHierarchicalContentProvider contentProvider, IDataSetDirectoryProvider directoryProvider, ISessionWorkspaceProvider sessionWorkspaceProviderOrNull, Map<String, String> parameterBindings, IMailClient mailClient, String userId, String userEmailOrNull, String sessionTokenOrNull) {
        this.service = service;
        this.hierarchicalContentProvider = contentProvider;
        this.directoryProvider = directoryProvider;
        this.parameterBindings = parameterBindings;
        this.mailClient = mailClient;
        this.userId = userId;
        this.userEmailOrNull = userEmailOrNull;
        this.sessionTokenOrNull = sessionTokenOrNull;
        this.sessionWorkspaceProviderOrNull = sessionWorkspaceProviderOrNull;
    }

    public IDataSetDirectoryProvider getDirectoryProvider() {
        return this.directoryProvider;
    }

    public ISessionWorkspaceProvider tryGetSessionWorkspaceProvider() {
        return this.sessionWorkspaceProviderOrNull;
    }

    public final Map<String, String> getParameterBindings() {
        return this.parameterBindings;
    }

    public final IMailClient getMailClient() {
        return this.mailClient;
    }

    public final String getUserId() {
        return this.userId;
    }

    public final String getUserEmailOrNull() {
        return this.userEmailOrNull;
    }

    public String trySessionToken() {
        return this.sessionTokenOrNull;
    }

    public IHierarchicalContentProvider getHierarchicalContentProvider() {
        final IHierarchicalContentProvider contentProvider = this.getContentProvider();
        return new IHierarchicalContentProvider(){

            @Override
            public IHierarchicalContent asContent(AbstractExternalData dataSet) {
                DataSetProcessingContext.this.assertAuthorization(dataSet.getCode());
                return contentProvider.asContent(dataSet);
            }

            @Override
            public IHierarchicalContent asContent(String dataSetCode) throws IllegalArgumentException {
                DataSetProcessingContext.this.assertAuthorization(dataSetCode);
                return contentProvider.asContent(dataSetCode);
            }

            @Override
            public IHierarchicalContent asContent(File datasetDirectory) {
                return contentProvider.asContent(datasetDirectory);
            }

            @Override
            public IHierarchicalContent asContent(IDatasetLocation datasetLocation) {
                return contentProvider.asContent(datasetLocation);
            }

            @Override
            public IHierarchicalContentProvider cloneFor(ISessionTokenProvider sessionTokenProvider) {
                return contentProvider.cloneFor(sessionTokenProvider);
            }
        };
    }

    private IHierarchicalContentProvider getContentProvider() {
        if (this.sessionTokenOrNull == null) {
            return this.hierarchicalContentProvider;
        }
        OpenBISSessionHolder sessionHolder = new OpenBISSessionHolder();
        sessionHolder.setSessionToken(this.sessionTokenOrNull);
        IHierarchicalContentProvider contentProvider = this.hierarchicalContentProvider.cloneFor(sessionHolder);
        return contentProvider;
    }

    public IHierarchicalContentProvider getHierarchicalContentProviderUnfiltered() {
        return this.hierarchicalContentProvider;
    }

    private void assertAuthorization(String dataSetCode) {
        if (this.sessionTokenOrNull == null) {
            operationLog.warn("Undefined user session token. Skip authorization check for data set " + dataSetCode + ".");
            return;
        }
        if (this.service == null) {
            operationLog.warn("Undefined service. Skip authorization check for data set " + dataSetCode + ".");
            return;
        }
        this.service.checkDataSetAccess(this.sessionTokenOrNull, dataSetCode);
    }
}

