/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AsyncCallbackWithProgressBar;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.help.HelpPageIdentifier;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.model.BaseEntityModel;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.CheckBoxField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.PropertyFieldFactory;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ScriptChooserField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.ColumnDefsAndConfigs;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IBrowserGridActionInvoker;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type.EntityTypePropertyTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type.SectionSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractRegistrationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.DialogWithOnlineHelpUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.IDelegatedAction;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.util.WindowUtils;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseModificationKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewETPTAssignment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import com.extjs.gxt.ui.client.Style;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.FieldEvent;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.Dialog;
import com.extjs.gxt.ui.client.widget.Label;
import com.extjs.gxt.ui.client.widget.MessageBox;
import com.extjs.gxt.ui.client.widget.Window;
import com.extjs.gxt.ui.client.widget.button.Button;
import com.extjs.gxt.ui.client.widget.form.CheckBox;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class PropertyTypeAssignmentGrid
extends TypedTableGrid<EntityTypePropertyType<?>> {
    public static final String BROWSER_ID = "openbis_property-type-assignment-browser";
    public static final String GRID_ID = "openbis_property-type-assignment-browser-grid";
    private final IDelegatedAction postRegistrationCallback;

    public static IDisposableComponent create(IViewContext<ICommonClientServiceAsync> viewContext) {
        return new PropertyTypeAssignmentGrid(viewContext).asDisposableWithoutToolbar();
    }

    private PropertyTypeAssignmentGrid(IViewContext<ICommonClientServiceAsync> viewContext) {
        super(viewContext, BROWSER_ID, true, DisplayTypeIDGenerator.PROPERTY_TYPE_ASSIGNMENT_BROWSER_GRID);
        this.extendBottomToolbar();
        this.postRegistrationCallback = this.createRefreshGridAction();
    }

    private void extendBottomToolbar() {
        this.addEntityOperationsLabel();
        Button editButton = this.createSelectedItemButton(this.viewContext.getMessage("edit", new Object[0]), new TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<EntityTypePropertyType<?>>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<EntityTypePropertyType<?>>> selectedItem, boolean keyPressed) {
                EntityTypePropertyType<?> etpt = selectedItem.getBaseObject().getObjectOrNull();
                if (etpt.isManagedInternally()) {
                    MessageBox.alert((String)"Error", (String)"Assignments of internally managed property types cannot be edited.", null);
                } else {
                    PropertyTypeAssignmentGrid.this.createEditDialog(etpt).show();
                }
            }
        });
        editButton.setId("openbis_property-type-assignment-browser-grid-edit");
        this.addButton(editButton);
        Button releaseButton = this.createSelectedItemButton(this.viewContext.getMessage("unassign_button_label", new Object[0]), new TypedTableGrid.ISelectedEntityInvoker<BaseEntityModel<TableModelRowWithObject<EntityTypePropertyType<?>>>>(){

            @Override
            public void invoke(BaseEntityModel<TableModelRowWithObject<EntityTypePropertyType<?>>> selectedItem, boolean keyPressed) {
                EntityTypePropertyType<?> etpt = selectedItem.getBaseObject().getObjectOrNull();
                PropertyTypeAssignmentGrid.this.unassignPropertyType(etpt);
            }
        });
        releaseButton.setId("openbis_property-type-assignment-browser-grid-release");
        this.addButton(releaseButton);
        this.addEntityOperationsSeparator();
    }

    private static ScriptChooserField createScriptChooserField(IViewContext<ICommonClientServiceAsync> viewContext, String initialValue, boolean visible, ScriptType scriptTypeOrNull, EntityKind entityKindOrNull) {
        ScriptChooserField field = ScriptChooserField.create(viewContext.getMessage("plugin", new Object[0]), true, initialValue, viewContext, scriptTypeOrNull, entityKindOrNull);
        FieldUtil.setVisibility(visible, new Field[]{field});
        return field;
    }

    private Window createEditDialog(final EntityTypePropertyType<?> etpt) {
        final EntityKind entityKind = etpt.getEntityKind();
        final String entityTypeCode = ((Code)etpt.getEntityType()).getCode();
        final String propertyTypeCode = etpt.getPropertyType().getCode();
        String title = this.viewContext.getMessage("edit_property_type_assignment_title", entityKind.getDescription(), entityTypeCode, propertyTypeCode);
        return new AbstractRegistrationDialog(this.viewContext, title, this.postRegistrationCallback){
            Script script;
            private boolean originalIsMandatory;
            private SectionSelectionWidget sectionSelectionWidget;
            private EntityTypePropertyTypeSelectionWidget etptSelectionWidget;
            private CheckBox mandatoryCheckbox;
            private Field<?> defaultValueField;
            private ScriptChooserField scriptChooser;
            private CheckBox shownInEditViewCheckBox;
            private CheckBox showRawValuesCheckBox;
            private Label loading;
            private boolean isLoaded;
            {
                super($anonymous0, $anonymous1, $anonymous2);
                this.setScrollMode(Style.Scroll.NONE);
                this.script = entityTypePropertyType.getScript();
                this.isLoaded = false;
                this.loading = new Label(PropertyTypeAssignmentGrid.this.viewContext.getMessage("load_in_progress", new Object[0]));
                this.addField((Widget)this.loading);
                PropertyTypeAssignmentGrid.this.viewContext.getCommonService().listPropertyTypeAssignments((EntityType)entityTypePropertyType.getEntityType(), new AbstractAsyncCallback<List<EntityTypePropertyType<?>>>(PropertyTypeAssignmentGrid.this.viewContext){

                    @Override
                    protected void process(List<EntityTypePropertyType<?>> etpts) {
                        form.remove((Widget)loading);
                        this.initFields(etpts);
                        isLoaded = true;
                    }
                });
            }

            private void initFields(List<EntityTypePropertyType<?>> etpts) {
                this.originalIsMandatory = etpt.isMandatory();
                this.mandatoryCheckbox = new CheckBoxField(PropertyTypeAssignmentGrid.this.viewContext.getMessage("mandatory", new Object[0]), false);
                this.mandatoryCheckbox.setValue(Boolean.valueOf(this.originalIsMandatory));
                if (this.script != null) {
                    this.mandatoryCheckbox.setVisible(false);
                }
                this.addField((Widget)this.mandatoryCheckbox);
                this.scriptChooser = PropertyTypeAssignmentGrid.createScriptChooserField(PropertyTypeAssignmentGrid.this.viewContext, this.script != null ? this.script.getName() : null, this.script != null, this.script != null ? this.script.getScriptType() : null, entityKind);
                this.addField((Widget)this.scriptChooser);
                this.shownInEditViewCheckBox = new CheckBoxField(PropertyTypeAssignmentGrid.this.viewContext.getMessage("shown_in_edit_view", new Object[0]), false);
                this.shownInEditViewCheckBox.setValue(Boolean.valueOf(etpt.isShownInEditView()));
                if (!etpt.isManaged()) {
                    this.shownInEditViewCheckBox.setVisible(false);
                }
                this.addField((Widget)this.shownInEditViewCheckBox);
                this.showRawValuesCheckBox = new CheckBoxField(PropertyTypeAssignmentGrid.this.viewContext.getMessage("show_raw_value", new Object[0]), false);
                this.showRawValuesCheckBox.setValue(Boolean.valueOf(etpt.getShowRawValue()));
                if (!etpt.isManaged()) {
                    this.showRawValuesCheckBox.setVisible(false);
                }
                this.addField((Widget)this.showRawValuesCheckBox);
                if (!this.originalIsMandatory) {
                    this.defaultValueField = (Field)PropertyFieldFactory.createField(etpt.getPropertyType(), false, PropertyTypeAssignmentGrid.this.viewContext.getMessage("default_update_value", new Object[0]), "default_value_field", null, PropertyTypeAssignmentGrid.this.viewContext).get();
                    this.defaultValueField.setToolTip(PropertyTypeAssignmentGrid.this.viewContext.getMessage("default_update_value_tooltip", new Object[0]));
                    this.addField((Widget)this.defaultValueField);
                    this.mandatoryCheckbox.addListener(Events.Change, (Listener)new Listener<FieldEvent>(){

                        public void handleEvent(FieldEvent be) {
                            defaultValueField.setVisible(this.getMandatoryValue() && !etpt.isDynamic());
                        }
                    });
                    this.mandatoryCheckbox.fireEvent(Events.Change);
                } else {
                    this.defaultValueField = null;
                }
                this.sectionSelectionWidget = this.createSectionSelectionWidget(etpts);
                this.sectionSelectionWidget.setSimpleValue(etpt.getSection());
                this.addField((Widget)this.sectionSelectionWidget);
                this.etptSelectionWidget = this.createETPTSelectionWidget(etpts);
                this.addField((Widget)this.etptSelectionWidget);
                DialogWithOnlineHelpUtils.addHelpButton(PropertyTypeAssignmentGrid.this.viewContext, this, this.createHelpPageIdentifier());
                this.layout();
                WindowUtils.resize(this, this.form.getElement());
            }

            private SectionSelectionWidget createSectionSelectionWidget(List<EntityTypePropertyType<?>> etpts) {
                return SectionSelectionWidget.create(PropertyTypeAssignmentGrid.this.viewContext, etpts);
            }

            private EntityTypePropertyTypeSelectionWidget createETPTSelectionWidget(List<EntityTypePropertyType<?>> allETPTs) {
                ArrayList etpts = new ArrayList();
                etpts.add(null);
                String initialPropertyTypeCodeOrNull = null;
                String previousPropertyTypeCodeOrNull = "(top)";
                for (EntityTypePropertyType<?> currentETPT : allETPTs) {
                    String currentPropertyTypeCode = currentETPT.getPropertyType().getCode();
                    if (!propertyTypeCode.equals(currentPropertyTypeCode)) {
                        etpts.add(currentETPT);
                        previousPropertyTypeCodeOrNull = currentPropertyTypeCode;
                        continue;
                    }
                    initialPropertyTypeCodeOrNull = previousPropertyTypeCodeOrNull;
                }
                EntityTypePropertyTypeSelectionWidget result = new EntityTypePropertyTypeSelectionWidget(PropertyTypeAssignmentGrid.this.viewContext, this.getId(), etpts, initialPropertyTypeCodeOrNull);
                FieldUtil.setMandatoryFlag(result, true);
                return result;
            }

            private String getSectionValue() {
                return this.sectionSelectionWidget.getSimpleValue();
            }

            private Long getPreviousETPTOrdinal() {
                return this.etptSelectionWidget.getSelectedEntityTypePropertyTypeOrdinal();
            }

            private String tryGetScriptNameValue() {
                if (this.scriptChooser == null) {
                    return null;
                }
                return (String)this.scriptChooser.getValue();
            }

            private String getDefaultValue() {
                if (this.defaultValueField != null) {
                    return PropertyFieldFactory.valueToString(this.defaultValueField.getValue());
                }
                return null;
            }

            private boolean getMandatoryValue() {
                return this.mandatoryCheckbox.getValue();
            }

            private boolean isShownInEditView() {
                if (!etpt.isManaged()) {
                    return !etpt.isDynamic();
                }
                return this.shownInEditViewCheckBox.getValue();
            }

            private boolean getShowRawValue() {
                if (!etpt.isManaged() || !this.isShownInEditView()) {
                    return false;
                }
                return this.showRawValuesCheckBox.getValue();
            }

            @Override
            protected void register(AsyncCallback<Void> registrationCallback) {
                if (this.isLoaded) {
                    ((ICommonClientServiceAsync)PropertyTypeAssignmentGrid.this.viewContext.getService()).updatePropertyTypeAssignment(new NewETPTAssignment(entityKind, propertyTypeCode, entityTypeCode, this.getMandatoryValue(), this.getDefaultValue(), this.getSectionValue(), this.getPreviousETPTOrdinal(), etpt.isDynamic(), etpt.isManaged(), this.tryGetScriptNameValue(), this.isShownInEditView(), this.getShowRawValue()), registrationCallback);
                }
            }

            private HelpPageIdentifier createHelpPageIdentifier() {
                return new HelpPageIdentifier(HelpPageIdentifier.HelpPageDomain.ASSIGNMENT, HelpPageIdentifier.HelpPageAction.EDIT);
            }
        };
    }

    private void unassignPropertyType(EntityTypePropertyType<?> etpt) {
        EntityKind entityKind = etpt.getEntityKind();
        String entityTypeCode = ((Code)etpt.getEntityType()).getCode();
        String propertyTypeCode = etpt.getPropertyType().getCode();
        IBrowserGridActionInvoker invoker = this.asActionInvoker();
        UnassignmentPreparationCallback callback = new UnassignmentPreparationCallback(this.viewContext, etpt, invoker);
        ((ICommonClientServiceAsync)this.viewContext.getService()).countPropertyTypedEntities(entityKind, propertyTypeCode, entityTypeCode, callback);
    }

    @Override
    protected String translateColumnIdToDictionaryKey(String columnID) {
        return columnID.toLowerCase();
    }

    @Override
    protected ColumnDefsAndConfigs<TableModelRowWithObject<EntityTypePropertyType<?>>> createColumnsDefinition() {
        ColumnDefsAndConfigs<TableModelRowWithObject<EntityTypePropertyType<?>>> schema = super.createColumnsDefinition();
        schema.setGridCellRendererFor("DESCRIPTION", this.createMultilineStringCellRenderer());
        return schema;
    }

    @Override
    protected List<String> getColumnIdsOfFilters() {
        return Arrays.asList("PROPERTY_TYPE_CODE", "ASSIGNED_TO", "TYPE_OF");
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<EntityTypePropertyType<?>>> resultSetConfig, final AbstractAsyncCallback<TypedTableResultSet<EntityTypePropertyType<?>>> callback) {
        AbstractAsyncCallback extendedCallback = new AbstractAsyncCallback<TypedTableResultSet<EntityTypePropertyType<?>>>(this.viewContext){

            @Override
            protected void process(TypedTableResultSet<EntityTypePropertyType<?>> result) {
                callback.onSuccess(result);
            }

            @Override
            public void finishOnFailure(Throwable caught) {
                callback.finishOnFailure(caught);
            }
        };
        ((ICommonClientServiceAsync)this.viewContext.getService()).listPropertyTypeAssignments(resultSetConfig, extendedCallback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<EntityTypePropertyType<?>>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportPropertyTypeAssignments(exportCriteria, callback);
    }

    @Override
    public DatabaseModificationKind[] getRelevantModifications() {
        return DatabaseModificationKind.any(DatabaseModificationKind.ObjectKind.PROPERTY_TYPE_ASSIGNMENT);
    }

    private static final class RefreshCallback
    extends AbstractAsyncCallback<Void> {
        private final IBrowserGridActionInvoker invoker;

        private RefreshCallback(IViewContext<?> viewContext, IBrowserGridActionInvoker invoker) {
            super(viewContext);
            this.invoker = invoker;
        }

        @Override
        protected void process(Void result) {
            this.invoker.refresh();
        }
    }

    private static final class UnassignmentConfirmationDialog
    extends Dialog {
        private final IViewContext<ICommonClientServiceAsync> viewContext;
        private final IBrowserGridActionInvoker invoker;
        private final EntityKind entityKind;
        private final String entityTypeCode;
        private final String propertyTypeCode;

        UnassignmentConfirmationDialog(IViewContext<ICommonClientServiceAsync> viewContext, EntityTypePropertyType<?> etpt, int numberOfProperties, IBrowserGridActionInvoker invoker) {
            this.viewContext = viewContext;
            this.invoker = invoker;
            this.setHeading(viewContext.getMessage("unassignment_confirmation_dialog_title", new Object[0]));
            this.setButtons("yesno");
            this.setHideOnButtonClick(true);
            this.setModal(true);
            this.entityKind = etpt.getEntityKind();
            this.entityTypeCode = ((Code)etpt.getEntityType()).getCode();
            this.propertyTypeCode = etpt.getPropertyType().getCode();
            String entityKindCode = this.entityKind.toString().toLowerCase();
            if (numberOfProperties == 0) {
                this.addText(viewContext.getMessage("unassignment_confirmation_template_without_properties", entityKindCode, this.entityTypeCode, this.propertyTypeCode));
            } else {
                this.addText(viewContext.getMessage("unassignment_confirmation_template_with_properties", entityKindCode, this.entityTypeCode, this.propertyTypeCode, numberOfProperties));
            }
            this.setWidth(400);
        }

        protected void onButtonPressed(Button button) {
            super.onButtonPressed(button);
            if (button.getItemId().equals("yes")) {
                this.viewContext.getService().unassignPropertyType(this.entityKind, this.propertyTypeCode, this.entityTypeCode, AsyncCallbackWithProgressBar.decorate(new RefreshCallback(this.viewContext, this.invoker), "Releasing assignment..."));
            }
        }
    }

    private static final class UnassignmentPreparationCallback
    extends AbstractAsyncCallback<Integer> {
        private final IViewContext<ICommonClientServiceAsync> commonViewContext;
        private final EntityTypePropertyType<?> etpt;
        private final IBrowserGridActionInvoker invoker;

        private UnassignmentPreparationCallback(IViewContext<ICommonClientServiceAsync> viewContext, EntityTypePropertyType<?> etpt, IBrowserGridActionInvoker invoker) {
            super(viewContext);
            this.commonViewContext = viewContext;
            this.etpt = etpt;
            this.invoker = invoker;
        }

        @Override
        protected void process(Integer result) {
            UnassignmentConfirmationDialog dialog = new UnassignmentConfirmationDialog(this.commonViewContext, this.etpt, result, this.invoker);
            dialog.show();
        }
    }
}

