/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.AbstractCommonTableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Code;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityTypePropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Vocabulary;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public class PropertyTypeProvider
extends AbstractCommonTableModelProvider<PropertyType> {
    public PropertyTypeProvider(ICommonServer commonServer, String sessionToken) {
        super(commonServer, sessionToken);
    }

    @Override
    protected TypedTableModel<PropertyType> createTableModel() {
        List<PropertyType> propertyTypes = this.commonServer.listPropertyTypes(this.sessionToken, true);
        TypedTableModelBuilder<PropertyType> builder = new TypedTableModelBuilder<PropertyType>();
        builder.addColumn("LABEL");
        builder.addColumn("CODE");
        builder.addColumn("DATA_TYPE").withDefaultWidth(200);
        builder.addColumn("DATA_TYPE_CODE").hideByDefault();
        builder.addColumn("VOCABULARY").hideByDefault();
        builder.addColumn("MATERIAL_TYPE").hideByDefault();
        builder.addColumn("XML_SCHEMA").hideByDefault();
        builder.addColumn("XSLT").hideByDefault();
        builder.addColumn("DESCRIPTION");
        builder.addColumn("SAMPLE_TYPES");
        builder.addColumn("EXPERIMENT_TYPES");
        builder.addColumn("MATERIAL_TYPES");
        builder.addColumn("DATA_SET_TYPES");
        for (PropertyType propertyType : propertyTypes) {
            builder.addRow(propertyType);
            builder.column("LABEL").addString(propertyType.getLabel());
            builder.column("CODE").addString(propertyType.getCode());
            builder.column("DATA_TYPE").addString(PropertyTypeProvider.renderDataType(propertyType));
            builder.column("DATA_TYPE_CODE").addString(propertyType.getDataType().getCode().name());
            Vocabulary vocabulary = propertyType.getVocabulary();
            builder.column("VOCABULARY").addString(vocabulary != null ? vocabulary.getCode() : null);
            MaterialType materialType = propertyType.getMaterialType();
            builder.column("MATERIAL_TYPE").addString(materialType != null ? materialType.getCode() : null);
            builder.column("XML_SCHEMA").addString(propertyType.getSchema());
            builder.column("XSLT").addString(propertyType.getTransformation());
            builder.column("DESCRIPTION").addString(propertyType.getDescription());
            builder.column("SAMPLE_TYPES").addString(PropertyTypeProvider.render(propertyType.getSampleTypePropertyTypes()));
            builder.column("EXPERIMENT_TYPES").addString(PropertyTypeProvider.render(propertyType.getExperimentTypePropertyTypes()));
            builder.column("MATERIAL_TYPES").addString(PropertyTypeProvider.render(propertyType.getMaterialTypePropertyTypes()));
            builder.column("DATA_SET_TYPES").addString(PropertyTypeProvider.render(propertyType.getDataSetTypePropertyTypes()));
        }
        return builder.getModel();
    }

    private static String render(List<? extends EntityTypePropertyType<?>> list) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (EntityTypePropertyType<?> etpt : list) {
            if (!first) {
                sb.append(", ");
            } else {
                first = false;
            }
            sb.append(PropertyTypeProvider.render(etpt));
        }
        return sb.toString();
    }

    private static String render(EntityTypePropertyType<?> etpt) {
        StringBuilder sb = new StringBuilder();
        sb.append(((Code)etpt.getEntityType()).getCode());
        if (etpt.isMandatory()) {
            sb.append(" *");
        }
        return sb.toString();
    }

    static String renderDataType(PropertyType entity) {
        DataTypeCode dataType = entity.getDataType().getCode();
        switch (dataType) {
            case BOOLEAN: {
                return "True / False";
            }
            case CONTROLLEDVOCABULARY: {
                return "Vocabulary: " + PropertyTypeProvider.tryGetVocabularyCode(entity);
            }
            case INTEGER: {
                return "Integer Number";
            }
            case MATERIAL: {
                String materialTypeCode = PropertyTypeProvider.tryGetMaterialTypeCode(entity);
                if (materialTypeCode == null) {
                    return "Material of Any Type";
                }
                return "Material of Type: " + materialTypeCode;
            }
            case REAL: {
                return "Float Number";
            }
            case TIMESTAMP: {
                return "Date and Time";
            }
            case VARCHAR: {
                return "Text";
            }
        }
        return dataType.name();
    }

    private static String tryGetVocabularyCode(PropertyType entity) {
        Vocabulary vocabulary = entity.getVocabulary();
        return vocabulary != null ? vocabulary.getCode() : null;
    }

    private static String tryGetMaterialTypeCode(PropertyType entity) {
        MaterialType materialType = entity.getMaterialType();
        return materialType != null ? materialType.getCode() : null;
    }
}

