/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.EntityTypeProvider;
import ch.systemsx.cisd.openbis.generic.shared.ICommonServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.SimpleYesNoRenderer;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.util.TypedTableModelBuilder;
import java.util.List;

public class SampleTypeProvider
extends EntityTypeProvider<SampleType> {
    public SampleTypeProvider(ICommonServer commonServer, String sessionToken) {
        super(commonServer, sessionToken);
    }

    @Override
    protected List<SampleType> listTypes() {
        return this.commonServer.listSampleTypes(this.sessionToken);
    }

    @Override
    protected void addMoreColumns(TypedTableModelBuilder<SampleType> builder) {
        builder.addColumn("IS_LISTABLE").hideByDefault();
        builder.addColumn("IS_SHOW_CONTAINER").withDefaultWidth(200).hideByDefault();
        builder.addColumn("IS_SHOW_PARENTS").withDefaultWidth(200).hideByDefault();
        builder.addColumn("SUBCODE_UNIQUE_LABEL").hideByDefault();
        builder.addColumn("AUTO_GENERATE_CODES_LABEL").hideByDefault();
        builder.addColumn("IS_SHOW_PARENT_METADATA").hideByDefault();
        builder.addColumn("GENERATED_CODE_PREFIX").hideByDefault();
    }

    @Override
    protected void addMoreCells(TypedTableModelBuilder<SampleType> builder, SampleType type) {
        builder.column("IS_LISTABLE").addString(SimpleYesNoRenderer.render(type.isListable()));
        builder.column("IS_SHOW_CONTAINER").addString(SimpleYesNoRenderer.render(type.isShowContainer()));
        builder.column("IS_SHOW_PARENTS").addString(SimpleYesNoRenderer.render(type.isShowParents()));
        builder.column("SUBCODE_UNIQUE_LABEL").addString(SimpleYesNoRenderer.render(type.isSubcodeUnique()));
        builder.column("AUTO_GENERATE_CODES_LABEL").addString(SimpleYesNoRenderer.render(type.isAutoGeneratedCode()));
        builder.column("IS_SHOW_PARENT_METADATA").addString(SimpleYesNoRenderer.render(type.isShowParentMetadata()));
        builder.column("GENERATED_CODE_PREFIX").addString(type.getGeneratedCodePrefix());
    }
}

