/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server;

import ch.systemsx.cisd.authentication.ISessionManager;
import ch.systemsx.cisd.openbis.common.spring.IInvocationLoggerContext;
import ch.systemsx.cisd.openbis.generic.server.AbstractServer;
import ch.systemsx.cisd.openbis.generic.server.TrackingServerLogger;
import ch.systemsx.cisd.openbis.generic.server.authorization.annotation.RolesAllowed;
import ch.systemsx.cisd.openbis.generic.server.business.IPropertiesBatchManager;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.datasetlister.IDatasetLister;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleLister;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.ITrackingServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.SearchlinkUtilities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListOrSearchSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TrackingDataSetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TrackingSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public final class TrackingServer
extends AbstractServer<ITrackingServer>
implements ITrackingServer {
    private final ICommonBusinessObjectFactory businessObjectFactory;

    public TrackingServer(ISessionManager<Session> sessionManager, IDAOFactory daoFactory, ICommonBusinessObjectFactory businessObjectFactory) {
        this(sessionManager, daoFactory, null, businessObjectFactory);
    }

    TrackingServer(ISessionManager<Session> sessionManager, IDAOFactory daoFactory, IPropertiesBatchManager propertiesBatchManager, ICommonBusinessObjectFactory businessObjectFactory) {
        super(sessionManager, daoFactory, propertiesBatchManager);
        this.businessObjectFactory = businessObjectFactory;
    }

    ICommonBusinessObjectFactory getBusinessObjectFactory() {
        return this.businessObjectFactory;
    }

    @Override
    public final ITrackingServer createLogger(IInvocationLoggerContext context) {
        return new TrackingServerLogger(this.getSessionManager(), context);
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public List<Sample> listSamples(String sessionToken, TrackingSampleCriteria criteria) {
        Session session = this.getSession(sessionToken);
        ISampleLister sampleLister = this.businessObjectFactory.createSampleLister(session);
        ListOrSearchSampleCriteria listerCriteria = new ListOrSearchSampleCriteria(criteria);
        listerCriteria.setEnrichDependentSamplesWithProperties(true);
        List<Sample> result = sampleLister.list(listerCriteria);
        this.fillSearchLinks(result, session.getBaseIndexURL());
        return result;
    }

    private void fillSearchLinks(List<Sample> samples, String baseIndexURL) {
        for (Sample sample : samples) {
            sample.setPermlink(SearchlinkUtilities.createSearchlinkURL(baseIndexURL, EntityKind.SAMPLE, sample.getCode()));
        }
    }

    @Override
    @RolesAllowed(value={RoleWithHierarchy.INSTANCE_ADMIN})
    public List<AbstractExternalData> listDataSets(String sessionToken, TrackingDataSetCriteria criteria) {
        Session session = this.getSession(sessionToken);
        IDatasetLister datasetLister = this.businessObjectFactory.createDatasetLister(session);
        List<AbstractExternalData> dataSets = datasetLister.listByTrackingCriteria(criteria);
        ISampleLister sampleLister = this.businessObjectFactory.createSampleLister(session);
        ListOrSearchSampleCriteria listerCriteria = new ListOrSearchSampleCriteria(this.extractConnectedSampleIds(dataSets));
        listerCriteria.setEnrichDependentSamplesWithProperties(true);
        List<Sample> enrichedSamples = sampleLister.list(listerCriteria);
        this.replaceConnectedSamples(dataSets, enrichedSamples);
        return dataSets;
    }

    private List<Long> extractConnectedSampleIds(List<AbstractExternalData> dataSets) {
        ArrayList<Long> sampleIds = new ArrayList<Long>();
        for (AbstractExternalData dataSet : dataSets) {
            assert (dataSet.getSample() != null) : "data set is not connected to a sample";
            sampleIds.add(dataSet.getSample().getId());
        }
        return sampleIds;
    }

    private void replaceConnectedSamples(List<AbstractExternalData> dataSets, List<Sample> enrichedSamples) {
        HashMap<Long, Sample> enrichedSamplesMap = new HashMap<Long, Sample>(enrichedSamples.size());
        for (Sample sample : enrichedSamples) {
            enrichedSamplesMap.put(sample.getId(), sample);
        }
        for (AbstractExternalData dataSet : dataSets) {
            Sample enrichedSample = (Sample)enrichedSamplesMap.get(dataSet.getSample().getId());
            assert (enrichedSample != null);
            dataSet.setSample(enrichedSample);
        }
    }
}

