/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.server.business.IRelationshipService;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.RelationshipUtils;
import ch.systemsx.cisd.openbis.generic.server.business.bo.util.SampleUtils;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.DAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IAuthSession;
import ch.systemsx.cisd.openbis.generic.shared.dto.IModifierAndModificationDateBean;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.RelationshipTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleRelationshipPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import javax.annotation.Resource;

public class RelationshipService
implements IRelationshipService {
    private static final String ERR_SAMPLE_PARENT_RELATIONSHIP_NOT_FOUND = "Sample '%s' did not have parent '%s'";
    private static final String ERR_DATASET_PARENT_RELATIONSHIP_NOT_FOUND = "DataSet '%s' did not have parent '%s'";
    private DAOFactory daoFactory;
    @Resource(name="relationship-service")
    private IRelationshipService service;

    @Override
    public void assignExperimentToProject(IAuthSession session, ExperimentPE experiment, ProjectPE project) {
        SampleUtils.setSamplesSpace(experiment, project.getSpace());
        ProjectPE previousProject = experiment.getProject();
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)previousProject, session);
        experiment.setProject(project);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)project, session);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)experiment, session);
    }

    @Override
    public void assignProjectToSpace(IAuthSession session, ProjectPE project, SpacePE space) {
        project.setSpace(space);
        for (ExperimentPE experiment : project.getExperiments()) {
            SampleUtils.setSamplesSpace(experiment, space);
        }
    }

    @Override
    public void assignSampleToExperiment(IAuthSession session, SamplePE sample, ExperimentPE experiment) {
        ExperimentPE currentExperiment = sample.getExperiment();
        if (currentExperiment != null) {
            this.service.checkCanUnassignSampleFromExperiment(session, sample);
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)currentExperiment, session);
        }
        sample.setExperiment(experiment);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, session);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)experiment, session);
        for (DataPE dataset : sample.getDatasets()) {
            RelationshipUtils.setExperimentForDataSet(dataset, experiment, session);
        }
    }

    @Override
    public void checkCanUnassignSampleFromExperiment(IAuthSession session, SamplePE sample) {
    }

    @Override
    public void unassignSampleFromExperiment(IAuthSession session, SamplePE sample) {
        ExperimentPE experiment = sample.getExperiment();
        if (experiment != null) {
            experiment.removeSample(sample);
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, session);
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)experiment, session);
        }
    }

    @Override
    public void assignSampleToSpace(IAuthSession session, SamplePE sample, SpacePE space) {
        sample.setDatabaseInstance(null);
        sample.setSpace(space);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, session);
    }

    @Override
    public void unshareSample(IAuthSession session, SamplePE sample, SpacePE space) {
        this.assignSampleToSpace(session, sample, space);
    }

    @Override
    public void shareSample(IAuthSession session, SamplePE sample) {
        SpacePE space = sample.getSpace();
        sample.setSpace(null);
        sample.setDatabaseInstance(space.getDatabaseInstance());
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, session);
    }

    @Override
    public void assignDataSetToExperiment(IAuthSession session, DataPE data, ExperimentPE experiment) {
        RelationshipUtils.setExperimentForDataSet(data, experiment, session);
        data.setSample(null);
    }

    @Override
    public void assignDataSetToSample(IAuthSession session, DataPE data, SamplePE sample) {
        ExperimentPE experiment = sample.getExperiment();
        RelationshipUtils.setExperimentForDataSet(data, experiment, session);
        RelationshipUtils.setSampleForDataSet(data, sample, session);
    }

    @Override
    public void addParentToSample(IAuthSession session, SamplePE sample, SamplePE parent) {
        PersonPE actor = session.tryGetPerson();
        RelationshipTypePE relationshipType = this.daoFactory.getRelationshipTypeDAO().tryFindRelationshipTypeByCode("$PARENT_CHILD");
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)sample, session);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)parent, session);
        sample.addParentRelationship(new SampleRelationshipPE(parent, sample, relationshipType, actor));
    }

    @Override
    public void removeParentFromSample(IAuthSession session, SamplePE sample, SamplePE parent) {
        for (SampleRelationshipPE relationship : sample.getParentRelationships()) {
            if (!relationship.getParentSample().equals(parent)) continue;
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)relationship.getChildSample(), session);
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)relationship.getParentSample(), session);
            sample.removeParentRelationship(relationship);
            return;
        }
        throw UserFailureException.fromTemplate(ERR_SAMPLE_PARENT_RELATIONSHIP_NOT_FOUND, sample.getCode(), parent.getCode());
    }

    @Override
    public void assignSampleToContainer(IAuthSession session, SamplePE sample, SamplePE container) {
        RelationshipUtils.setContainerForSample(sample, container, session);
    }

    @Override
    public void removeSampleFromContainer(IAuthSession session, SamplePE sample) {
        RelationshipUtils.setContainerForSample(sample, null, session);
    }

    @Override
    public void addParentToDataSet(IAuthSession session, DataPE data, DataPE parent) {
        PersonPE actor = session.tryGetPerson();
        DataSetRelationshipPE relationship = new DataSetRelationshipPE(parent, data, actor);
        data.addParentRelationship(relationship);
        parent.addChildRelationship(relationship);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)data, session);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)parent, session);
    }

    @Override
    public void removeParentFromDataSet(IAuthSession session, DataPE data, DataPE parent) {
        DataSetRelationshipPE remove = null;
        for (DataSetRelationshipPE r : data.getParentRelationships()) {
            if (!r.getParentDataSet().equals(parent)) continue;
            remove = r;
            break;
        }
        if (remove == null) {
            throw UserFailureException.fromTemplate(ERR_DATASET_PARENT_RELATIONSHIP_NOT_FOUND, data.getCode(), parent.getCode());
        }
        data.removeParentRelationship(remove);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)data, session);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)parent, session);
    }

    @Override
    public void assignDataSetToContainer(IAuthSession session, DataPE data, DataPE container) {
        PersonPE modifier = session.tryGetPerson();
        DataPE oldContainer = data.getContainer();
        if (oldContainer != null) {
            oldContainer.removeComponent(data);
            RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)oldContainer, session);
        }
        container.addComponent(data, modifier);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)container, session);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)data, session);
    }

    @Override
    public void removeDataSetFromContainer(IAuthSession session, DataPE data) {
        DataPE container = data.getContainer();
        container.removeComponent(data);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)container, session);
        RelationshipUtils.updateModificationDateAndModifier((IModifierAndModificationDateBean)data, session);
    }

    public void setDaoFactory(DAOFactory daoFactory) {
        this.daoFactory = daoFactory;
    }
}

