/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator;

import ch.systemsx.cisd.common.jython.evaluator.Evaluator;
import ch.systemsx.cisd.common.jython.evaluator.EvaluatorException;
import ch.systemsx.cisd.openbis.generic.server.JythonEvaluatorPool;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.DynamicPropertyFunctions;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.dynamic_property.calculator.api.IDynamicPropertyCalculator;
import ch.systemsx.cisd.openbis.generic.shared.calculator.AbstractCalculator;
import ch.systemsx.cisd.openbis.generic.shared.hotdeploy_plugins.api.IEntityAdaptor;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IAtomicEvaluation;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IEvaluationRunner;

public class JythonDynamicPropertyCalculator
implements IDynamicPropertyCalculator {
    private static final String ENTITY_VARIABLE_NAME = "entity";
    private static final String INVOKE_CALCULATE_EXPR = "calculate()";
    private final IEvaluationRunner runner;

    public static JythonDynamicPropertyCalculator create(String expression) {
        String calculatedExpression = expression;
        String initialScript = AbstractCalculator.getBasicInitialScript();
        initialScript = String.valueOf(initialScript) + AbstractCalculator.importFunctions(DynamicPropertyFunctions.class);
        if (Evaluator.isMultiline(expression)) {
            initialScript = String.valueOf(initialScript) + expression;
            calculatedExpression = INVOKE_CALCULATE_EXPR;
        }
        if (JythonEvaluatorPool.INSTANCE != null) {
            return new JythonDynamicPropertyCalculator(JythonEvaluatorPool.INSTANCE.getRunner(calculatedExpression, Math.class, initialScript));
        }
        return new JythonDynamicPropertyCalculator(calculatedExpression, initialScript);
    }

    private JythonDynamicPropertyCalculator(String expression, String script) {
        this(new IEvaluationRunner(expression, script){
            private Evaluator evaluator;
            {
                this.evaluator = new Evaluator(string, Math.class, string2);
            }

            @Override
            public <T> T evaluate(IAtomicEvaluation<T> evaluation) {
                return evaluation.evaluate(this.evaluator);
            }
        });
    }

    private JythonDynamicPropertyCalculator(IEvaluationRunner runner) {
        this.runner = runner;
    }

    @Override
    public String eval(final IEntityAdaptor entity) throws EvaluatorException {
        return this.runner.evaluate(new IAtomicEvaluation<String>(){

            @Override
            public String evaluate(Evaluator evaluator) {
                evaluator.set(JythonDynamicPropertyCalculator.ENTITY_VARIABLE_NAME, entity);
                return evaluator.evalAsStringLegacy2_2();
            }
        });
    }

    public void checkScriptCompilation() {
        this.runner.evaluate(new IAtomicEvaluation<Void>(){

            @Override
            public Void evaluate(Evaluator evaluator) {
                return null;
            }
        });
    }
}

