/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders.bioformats;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import loci.common.IRandomAccess;

final class BioFormatsRandomAccessAdapter
implements IRandomAccess {
    private final IRandomAccessFile randomAccessFile;

    public BioFormatsRandomAccessAdapter(IRandomAccessFile randomAccessFile) {
        this.randomAccessFile = randomAccessFile;
    }

    public void close() throws IOException {
        try {
            this.randomAccessFile.close();
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public int read(byte[] b) throws IOException {
        try {
            return this.randomAccessFile.read(b);
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return this.randomAccessFile.read(b, off, len);
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public long getFilePointer() throws IOException {
        try {
            return this.randomAccessFile.getFilePointer();
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public void seek(long pos) throws IOException {
        try {
            this.randomAccessFile.seek(pos);
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public long length() throws IOException {
        try {
            return this.randomAccessFile.length();
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public void readFully(byte[] b) throws IOException {
        try {
            this.randomAccessFile.readFully(b);
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        try {
            this.randomAccessFile.readFully(b, off, len);
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public int skipBytes(int n) throws IOException {
        try {
            return this.randomAccessFile.skipBytes(n);
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public boolean readBoolean() throws IOException {
        try {
            return this.randomAccessFile.readBoolean();
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public byte readByte() throws IOException {
        try {
            return this.randomAccessFile.readByte();
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public int readUnsignedByte() throws IOException {
        try {
            return this.randomAccessFile.readUnsignedByte();
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public short readShort() throws IOException {
        try {
            return this.randomAccessFile.readShort();
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public int readUnsignedShort() throws IOException {
        try {
            return this.randomAccessFile.readUnsignedShort();
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public char readChar() throws IOException {
        try {
            return this.randomAccessFile.readChar();
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public int readInt() throws IOException {
        try {
            return this.randomAccessFile.readInt();
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public long readLong() throws IOException {
        try {
            return this.randomAccessFile.readLong();
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public float readFloat() throws IOException {
        try {
            return this.randomAccessFile.readFloat();
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public double readDouble() throws IOException {
        try {
            return this.randomAccessFile.readDouble();
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public String readLine() throws IOException {
        try {
            return this.randomAccessFile.readLine();
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public String readUTF() throws IOException {
        try {
            return this.randomAccessFile.readUTF();
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public void write(int b) throws IOException {
        try {
            this.randomAccessFile.write(b);
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public void write(byte[] b) throws IOException {
        try {
            this.randomAccessFile.write(b);
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public void write(byte[] b, int off, int len) throws IOException {
        try {
            this.randomAccessFile.write(b, off, len);
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public void writeBoolean(boolean v) throws IOException {
        try {
            this.randomAccessFile.writeBoolean(v);
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public void writeByte(int v) throws IOException {
        try {
            this.randomAccessFile.writeByte(v);
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public void writeShort(int v) throws IOException {
        try {
            this.randomAccessFile.writeShort(v);
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public void writeChar(int v) throws IOException {
        try {
            this.randomAccessFile.writeChar(v);
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public void writeInt(int v) throws IOException {
        try {
            this.randomAccessFile.writeInt(v);
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public void writeLong(long v) throws IOException {
        try {
            this.randomAccessFile.writeLong(v);
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public void writeFloat(float v) throws IOException {
        try {
            this.randomAccessFile.writeFloat(v);
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public void writeDouble(double v) throws IOException {
        try {
            this.randomAccessFile.writeDouble(v);
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public void writeBytes(String s) throws IOException {
        try {
            this.randomAccessFile.writeBytes(s);
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public void writeChars(String s) throws IOException {
        try {
            this.randomAccessFile.writeChars(s);
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public void writeUTF(String str) throws IOException {
        try {
            this.randomAccessFile.writeUTF(str);
        }
        catch (IOExceptionUnchecked ex) {
            throw ex.getCause();
        }
    }

    public ByteOrder getOrder() {
        return this.randomAccessFile.getByteOrder();
    }

    public void setOrder(ByteOrder order) {
        this.randomAccessFile.setByteOrder(order);
    }

    public void write(ByteBuffer buf) throws IOException {
        this.write(buf, 0, buf.capacity());
    }

    public void write(ByteBuffer buffer, int offset, int len) throws IOException {
        if (buffer.hasArray()) {
            this.write(buffer.array(), offset, len);
        } else {
            int pos = buffer.position();
            buffer.position(offset);
            byte[] tbuf = new byte[4096];
            int remaining = len;
            while (remaining > 0) {
                int bytesToRead = Math.min(remaining, tbuf.length);
                buffer.get(tbuf, 0, bytesToRead);
                remaining -= bytesToRead;
                this.write(tbuf, 0, bytesToRead);
            }
            buffer.position(pos);
        }
    }

    public int read(ByteBuffer buffer) throws IOException {
        return this.read(buffer, 0, buffer.capacity());
    }

    public int read(ByteBuffer buffer, int offset, int len) throws IOException {
        if (buffer.hasArray()) {
            return this.read(buffer.array(), offset, len);
        }
        int pos = buffer.position();
        buffer.position(offset);
        byte[] tbuf = new byte[4096];
        int remaining = len;
        int bytesTotallyRead = 0;
        while (remaining > 0) {
            int bytesRead = this.read(tbuf, 0, remaining);
            remaining -= bytesRead;
            bytesTotallyRead += bytesRead;
            buffer.put(tbuf, 0, bytesRead);
        }
        buffer.position(pos);
        return bytesTotallyRead;
    }
}

