/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.client.application.page;

import ch.systemsx.cisd.cifex.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.cifex.client.application.IHistoryController;
import ch.systemsx.cisd.cifex.client.application.ViewContext;
import ch.systemsx.cisd.cifex.client.application.grid.GridUtils;
import ch.systemsx.cisd.cifex.client.application.grid.GridWidget;
import ch.systemsx.cisd.cifex.client.application.model.AbstractFileGridModel;
import ch.systemsx.cisd.cifex.client.application.model.UserGridModel;
import ch.systemsx.cisd.cifex.client.application.page.AbstractMainPageTabController;
import ch.systemsx.cisd.cifex.client.application.page.UserActionGridCellListener;
import ch.systemsx.cisd.cifex.client.application.utils.MessageDictionary;
import ch.systemsx.cisd.cifex.shared.basic.dto.UserInfoDTO;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.google.gwt.user.client.ui.Widget;
import java.util.ArrayList;
import java.util.List;

final class InviteTabController
extends AbstractMainPageTabController {
    InviteTabController(ViewContext context, List<GridWidget<AbstractFileGridModel>> fileGridWidgets) {
        super(context, fileGridWidgets);
    }

    @Override
    protected final Widget getWidget() {
        ContentPanel contentPanel = this.createOutermostWidgetContainer();
        UserInfoDTO user = this.context.getModel().getUser();
        ContentPanel createUserPanel = InviteTabController.createUserPanel(user.isAdmin(), this.context);
        InviteTabController.addWidgetRow(contentPanel, (Widget)createUserPanel);
        InviteTabController.createListCreatedUserPanel(contentPanel, this.context);
        return contentPanel;
    }

    protected void onShow() {
        this.context.getPageController().setCurrentPage(IHistoryController.Page.INVITE_PAGE);
    }

    private static void createListCreatedUserPanel(ContentPanel listCreatedUserPanel, ViewContext context) {
        GridWidget<UserGridModel> gridWidget = GridUtils.createUserGrid(new ArrayList<UserInfoDTO>(), false, context);
        gridWidget.getGrid().getView().setEmptyText(MessageDictionary.msg(MessageDictionary.LIST_USERS_LOADING_MSG));
        gridWidget.getGrid().addListener(Events.CellClick, (Listener)new UserActionGridCellListener(context, null, gridWidget));
        InviteTabController.addTitleRow(listCreatedUserPanel, MessageDictionary.msg(MessageDictionary.LIST_OWNUSERS_GRID_TITLE));
        InviteTabController.addWidgetRow(listCreatedUserPanel, (Widget)gridWidget.getWidget());
        context.getCifexService().listUsersOwnedBy(context.getModel().getUser().getID(), new CreatedUserAsyncCallback(context, gridWidget));
    }

    @Override
    protected IHistoryController.Page getPageIdentifier() {
        return IHistoryController.Page.INVITE_PAGE;
    }

    private static final class CreatedUserAsyncCallback
    extends AbstractAsyncCallback<List<UserInfoDTO>> {
        private final GridWidget<UserGridModel> userGrid;

        CreatedUserAsyncCallback(ViewContext context, GridWidget<UserGridModel> userGrid) {
            super(context);
            this.userGrid = userGrid;
        }

        public final void onSuccess(List<UserInfoDTO> result) {
            this.userGrid.getGrid().getView().setEmptyText(MessageDictionary.msg(MessageDictionary.LIST_USERS_EMPTY_MSG));
            this.userGrid.setDataAndRefresh(UserGridModel.convert(this.getViewContext(), result));
        }

        @Override
        public void onFailure(Throwable caught) {
            this.userGrid.getGrid().getView().setEmptyText(MessageDictionary.msg(MessageDictionary.LIST_USERS_EMPTY_MSG));
            super.onFailure(caught);
        }
    }
}

