/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client;

import ch.systemsx.cisd.base.exceptions.InterruptedExceptionUnchecked;
import ch.systemsx.cisd.cifex.rpc.FilePreregistrationDTO;
import ch.systemsx.cisd.cifex.rpc.ICIFEXRPCService;
import ch.systemsx.cisd.cifex.rpc.client.AbstractUploadDownload;
import ch.systemsx.cisd.cifex.rpc.client.FileWithOverrideName;
import ch.systemsx.cisd.cifex.rpc.client.ICIFEXUploader;
import ch.systemsx.cisd.cifex.rpc.client.gui.IProgressListener;
import ch.systemsx.cisd.cifex.rpc.io.ISimpleChecksummingProgressListener;
import ch.systemsx.cisd.cifex.rpc.io.ResumingAndChecksummingInputStream;
import ch.systemsx.cisd.cifex.shared.basic.dto.FileInfoDTO;
import ch.systemsx.cisd.common.concurrent.MonitoringProxy;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.springframework.remoting.RemoteAccessException;

public final class Uploader
extends AbstractUploadDownload
implements ICIFEXUploader {
    private final MonitoringProxy<IFileUploader> proxyForOperation = this.createFileUploaderProxy();
    private final IFileUploader retryingFileUploader = this.proxyForOperation.get();

    public Uploader(ICIFEXRPCService service, String sessionID) {
        super(service, sessionID);
    }

    @Override
    protected MonitoringProxy<?> getProxyForOperation() {
        return this.proxyForOperation;
    }

    private MonitoringProxy<IFileUploader> createFileUploaderProxy() {
        IFileUploader rawFileUploader = new IFileUploader(){

            @Override
            public boolean uploadFile(File file, String overrideNameOrNull, String comment, Set<Long> fileIds, MonitoringProxy.IMonitorCommunicator communicator) throws IOException {
                Uploader.this.doUploadFile(file, overrideNameOrNull, comment, fileIds, communicator);
                return true;
            }

            @Override
            public void shareFiles(List<Long> fileIds, String recipientsOrNull) {
                Uploader.this.service.shareFiles(Uploader.this.sessionID, new ArrayList<Long>(fileIds), recipientsOrNull);
            }
        };
        AbstractUploadDownload.InvocationLogger logger = new AbstractUploadDownload.InvocationLogger(this, this.reportFinalException);
        return MonitoringProxy.create(IFileUploader.class, rawFileUploader).exceptionClassSuitableForRetrying(RemoteAccessException.class).timing(TIMING).errorValueOnInterrupt().errorTypeValueMapping(Boolean.TYPE, false).invocationLog(logger);
    }

    @Override
    public void addProgressListener(IProgressListener uploadListener) {
        this.listeners.add(uploadListener);
    }

    /*
     * Exception decompiling
     */
    @Override
    public void upload(List<FileWithOverrideName> filesWithOverrideName, String recipientsOrNull, String comment) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[DOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void doUploadFile(File file, String overrideNameOrNull, String comment, Set<Long> fileIds, final MonitoringProxy.IMonitorCommunicator communicator) throws IOException {
        FileUtilities.checkInputFile(file);
        final long fileSize = file.length();
        String filePath = overrideNameOrNull == null ? file.getCanonicalPath() : overrideNameOrNull;
        FilePreregistrationDTO fileSpecs = new FilePreregistrationDTO(filePath, fileSize);
        ResumingAndChecksummingInputStream contentStream = null;
        try {
            long fileId;
            contentStream = new ResumingAndChecksummingInputStream(file, 131072L, new ISimpleChecksummingProgressListener(){
                long lastUpdated = System.currentTimeMillis();

                @Override
                public void update(long bytesRead, int crc32Value) {
                    if (Uploader.this.isCancelled() || communicator.isCancelled()) {
                        throw new InterruptedExceptionUnchecked();
                    }
                    communicator.update();
                    long now = System.currentTimeMillis();
                    if (now - this.lastUpdated > 1000L || bytesRead == fileSize) {
                        Uploader.this.fireProgressEvent(bytesRead, fileSize);
                        this.lastUpdated = now;
                    }
                }

                @Override
                public void exceptionThrown(IOException e) {
                }
            }, ResumingAndChecksummingInputStream.ChecksumHandling.COMPUTE_AND_APPEND);
            if (this.isCancelled() || communicator.isCancelled()) {
                throw new InterruptedExceptionUnchecked();
            }
            FileInfoDTO resumeFileInfoOrNull = this.tryGetFileInfoForResumeUpload(contentStream, fileSpecs);
            if (this.isCancelled() || communicator.isCancelled()) {
                throw new InterruptedExceptionUnchecked();
            }
            if (resumeFileInfoOrNull != null) {
                this.fireProgressEvent(resumeFileInfoOrNull.getSize(), fileSize);
                this.service.resumeUpload(this.sessionID, resumeFileInfoOrNull.getID(), resumeFileInfoOrNull.getSize(), comment, contentStream);
                fileId = resumeFileInfoOrNull.getID();
            } else {
                this.fireProgressEvent(0L, fileSize);
                fileId = this.service.upload(this.sessionID, fileSpecs, comment, contentStream);
            }
            if (communicator.isCancelled()) {
                throw new InterruptedExceptionUnchecked();
            }
            fileIds.add(fileId);
            if (fileSize != file.length()) {
                this.service.deleteFile(this.sessionID, fileId);
                throw EnvironmentFailureException.fromTemplate("File size has changed during upload [expected: %d, found: %d]", fileSize, file.length());
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(contentStream);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)contentStream);
    }

    private FileInfoDTO tryGetFileInfoForResumeUpload(ResumingAndChecksummingInputStream contentStream, FilePreregistrationDTO fileSpecs) throws IOException {
        FileInfoDTO uploadCandidateOrNull = this.service.tryGetUploadResumeCandidate(this.sessionID, fileSpecs);
        if (uploadCandidateOrNull != null && uploadCandidateOrNull.getSize() <= contentStream.getLength()) {
            contentStream.setStartPos(uploadCandidateOrNull.getSize());
            if (contentStream.getCrc32Value() == uploadCandidateOrNull.getCrc32Value().intValue()) {
                return uploadCandidateOrNull;
            }
            contentStream.setStartPos(0L);
        }
        return null;
    }

    private static interface IFileUploader {
        public boolean uploadFile(File var1, String var2, String var3, Set<Long> var4, MonitoringProxy.IMonitorCommunicator var5) throws IOException;

        public void shareFiles(List<Long> var1, String var2);
    }
}

