/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.client.gui;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.cifex.rpc.client.encryption.OpenPGPSymmetricKeyEncryption;
import ch.systemsx.cisd.cifex.rpc.client.gui.AbstractSwingGUI;
import ch.systemsx.cisd.cifex.rpc.client.gui.FileDownloadClientModel;
import ch.systemsx.cisd.cifex.rpc.client.gui.PassphraseDialog;
import ch.systemsx.cisd.cifex.shared.basic.dto.FileInfoDTO;
import ch.systemsx.cisd.common.exceptions.FileExistsException;
import ch.systemsx.cisd.common.filesystem.IFileOverwriteStrategy;
import java.io.File;
import java.io.IOException;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.bouncycastle.openpgp.PGPDataValidationException;

final class FileDownloadOperation
implements Runnable {
    private final FileDownloadClientModel tableModel;
    private final FileDownloadClientModel.FileDownloadInfo fileDownloadInfo;
    private final File downloadDirectory;
    private String passphrase;
    private boolean decryptionCancelled = false;
    private boolean deleteEncryptedFileAfterSuccessfulDecryption;

    FileDownloadOperation(FileDownloadClientModel model, FileDownloadClientModel.FileDownloadInfo info, File downloadDirectory, String passphrase, boolean deleteEncryptedFileAfterSuccessfulDecryption) {
        this.tableModel = model;
        this.fileDownloadInfo = info;
        this.downloadDirectory = downloadDirectory;
        this.passphrase = passphrase;
        this.deleteEncryptedFileAfterSuccessfulDecryption = deleteEncryptedFileAfterSuccessfulDecryption;
    }

    @Override
    public void run() {
        block10: {
            try {
                try {
                    File file;
                    if (this.fileDownloadInfo.getStatus() == FileDownloadClientModel.FileDownloadInfo.Status.QUEUED_FOR_DOWNLOAD) {
                        this.tableModel.fireChanged(this.fileDownloadInfo.getFileInfoDTO().getID(), FileDownloadClientModel.FileDownloadInfo.Status.DOWNLOADING);
                        file = this.tableModel.getDownloader().download(this.fileDownloadInfo.getFileInfoDTO().getID(), this.downloadDirectory, null, this.createFileResumeOrOverwriteStrategyAskUser(this.fileDownloadInfo.getFileInfoDTO()));
                        this.fileDownloadInfo.setFile(file);
                    } else {
                        file = this.fileDownloadInfo.getFile();
                    }
                    if (this.passphrase.length() <= 0) break block10;
                    try {
                        this.decrypt(file);
                        this.removeEncryptedIfRequested(file);
                    }
                    catch (Throwable th) {
                        this.tableModel.fireChanged(FileDownloadClientModel.FileDownloadInfo.Status.COMPLETED_DOWNLOAD);
                        AbstractSwingGUI.notifyUserOfThrowable(this.tableModel.getMainWindow(), this.fileDownloadInfo.getFileInfoDTO().getName(), "Decrypting", th, null);
                    }
                }
                catch (Throwable th) {
                    Throwable actualTh;
                    this.tableModel.fireChanged(this.fileDownloadInfo.getFileInfoDTO().getID(), FileDownloadClientModel.FileDownloadInfo.Status.FAILED);
                    Throwable throwable = actualTh = th instanceof Error ? th : CheckedExceptionTunnel.unwrapIfNecessary((Exception)th);
                    if (!(actualTh instanceof FileExistsException)) {
                        AbstractSwingGUI.notifyUserOfThrowable(this.tableModel.getMainWindow(), this.fileDownloadInfo.getFileInfoDTO().getName(), "Downloading", th, null);
                    }
                    this.tableModel.resetCurrentlyDownloadingFile();
                }
            }
            finally {
                this.tableModel.resetCurrentlyDownloadingFile();
            }
        }
    }

    private void removeEncryptedIfRequested(File file) {
        if (this.deleteEncryptedFileAfterSuccessfulDecryption && !this.decryptionCancelled && !file.delete()) {
            JOptionPane.showMessageDialog(this.tableModel.getMainWindow(), "Failed to delete file '" + file.getAbsolutePath() + "'.", "Warning", 2);
        }
    }

    private void decrypt(File file) {
        boolean ok = false;
        while (!ok) {
            try {
                this.tableModel.fireChanged(this.fileDownloadInfo.getFileInfoDTO().getID(), FileDownloadClientModel.FileDownloadInfo.Status.DECRYPTING);
                File clearTextFile = OpenPGPSymmetricKeyEncryption.decrypt(file, null, this.passphrase, this.createDecryptFileOverwriteStrategyAskUser());
                this.tableModel.fireChanged(FileDownloadClientModel.FileDownloadInfo.Status.COMPLETED_DOWNLOAD_AND_DECRYPTION);
                String filenameEncrypted = this.fileDownloadInfo.getFileInfoDTO().getName();
                String filenameDecrypted = clearTextFile.getName();
                if (!filenameEncrypted.equals(String.valueOf(filenameDecrypted) + ".pgp")) {
                    JOptionPane.showMessageDialog(this.tableModel.getMainWindow(), "File on Server: " + this.fileDownloadInfo.getFileInfoDTO().getName() + "\n" + "Decrypted file: " + clearTextFile.getPath(), "File Decryption", 1);
                }
                ok = true;
            }
            catch (CheckedExceptionTunnel ex) {
                Exception actualEx = CheckedExceptionTunnel.unwrapIfNecessary(ex);
                if (actualEx instanceof PGPDataValidationException) {
                    this.passphrase = PassphraseDialog.tryGetPassphraseForDecryptRetry(this.tableModel.getMainWindow(), "File: '" + this.fileDownloadInfo.getFileInfoDTO().getName() + "'", "<div color='red'>Wrong passphrase, please try again.</div>");
                    if (!StringUtils.isEmpty((String)this.passphrase)) continue;
                    this.cancelDecryption();
                    ok = true;
                    continue;
                }
                if (actualEx instanceof FileExistsException) {
                    this.cancelDecryption();
                    ok = true;
                    continue;
                }
                this.decryptionCancelled = true;
                throw ex;
            }
        }
    }

    private IFileOverwriteStrategy createDecryptFileOverwriteStrategyAskUser() {
        return new IFileOverwriteStrategy(){

            @Override
            public boolean overwriteAllowed(File outputFile) {
                int answer = JOptionPane.showOptionDialog(FileDownloadOperation.this.tableModel.getMainWindow(), "The decrypted file '" + outputFile.getAbsolutePath() + "' already exists. " + "Overwrite?", "File exists", 0, 3, null, new Object[]{"Yes", "No"}, "No");
                return answer == 0;
            }
        };
    }

    private IFileOverwriteStrategy createFileResumeOrOverwriteStrategyAskUser(final FileInfoDTO fileInfo) {
        return new IFileOverwriteStrategy(){

            @Override
            public boolean overwriteAllowed(File outputFile) {
                FileOverwriteAction action;
                long outputFileLength = outputFile.length();
                if (outputFileLength <= fileInfo.getSize()) {
                    int answer = JOptionPane.showOptionDialog(FileDownloadOperation.this.tableModel.getMainWindow(), "<html>The file to download '" + outputFile.getAbsolutePath() + "' already exists.<br>Your options are:<ol>" + "<li>Skip file (don't touch local file)" + "<li>Resume download of file from server" + "<li>Replace local file with file from server" + "</ol></html>", "File exists", -1, 3, null, new Object[]{"Skip", "Resume", "Replace"}, "Skip");
                    action = answer == 0 ? FileOverwriteAction.VETO : (answer == 1 ? FileOverwriteAction.RESUME : FileOverwriteAction.REPLACE);
                } else {
                    int answer = JOptionPane.showOptionDialog(FileDownloadOperation.this.tableModel.getMainWindow(), "A file '" + outputFile.getAbsolutePath() + "' already exists but is unsuitable " + "for resume.\nReplace with file from server?", "File exists", 0, 3, null, new Object[]{"Yes", "No"}, "No");
                    FileOverwriteAction fileOverwriteAction = action = answer == 0 ? FileOverwriteAction.REPLACE : FileOverwriteAction.VETO;
                }
                if (FileOverwriteAction.REPLACE == action && !outputFile.delete()) {
                    throw CheckedExceptionTunnel.wrapIfNecessary(new IOException("Cannot delete file '" + outputFile.getAbsolutePath() + "'."));
                }
                return FileOverwriteAction.VETO != action;
            }
        };
    }

    private void cancelDecryption() {
        this.decryptionCancelled = true;
        this.tableModel.fireChanged(FileDownloadClientModel.FileDownloadInfo.Status.COMPLETED_DOWNLOAD);
    }

    private static enum FileOverwriteAction {
        REPLACE,
        RESUME,
        VETO;

    }
}

