/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.business.dataaccess.db.migration;

import ch.systemsx.cisd.dbmigration.DatabaseConfigurationContext;
import ch.systemsx.cisd.dbmigration.DatabaseEngine;
import ch.systemsx.cisd.dbmigration.java.IMigrationStep;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class MigrationStepFrom009To010
implements IMigrationStep {
    private final boolean isPostgreSQL;

    public MigrationStepFrom009To010(DatabaseConfigurationContext context) {
        this.isPostgreSQL = DatabaseEngine.POSTGRESQL.getCode().equals(context.getDatabaseEngineCode());
    }

    @Override
    public void performPreMigration(SimpleJdbcTemplate simpleJdbcTemplate, DataSource dataSource) throws DataAccessException {
    }

    @Override
    public void performPostMigration(SimpleJdbcTemplate simpleJdbcTemplate, DataSource dataSource) throws DataAccessException {
        simpleJdbcTemplate.update("create domain user_code as varchar(50)", new Object[0]);
        if (this.isPostgreSQL) {
            simpleJdbcTemplate.update("alter table users rename column user_id to user_code", new Object[0]);
            simpleJdbcTemplate.update("alter table users alter column user_code type user_code", new Object[0]);
        } else {
            simpleJdbcTemplate.update("alter table users alter column user_id rename to user_code", new Object[0]);
        }
        simpleJdbcTemplate.update("drop domain user_id", new Object[0]);
        List independentUsers = simpleJdbcTemplate.query("select id, file_retention from users u1 where is_permanent or user_id_registrator is null or (select is_admin from users u2 where u1.user_id_registrator = u2.id)", (ParameterizedRowMapper)new IdFileRententionRowMapper(), new Object[0]);
        for (IdFileRentionHolder userIdFileRention : independentUsers) {
            long quotaGroupId = simpleJdbcTemplate.queryForLong("select nextval('quota_group_id_seq')", new Object[0]);
            simpleJdbcTemplate.update("insert into quota_groups (id, file_retention, user_retention) values (?,?,?)", new Object[]{quotaGroupId, userIdFileRention.fileRetention, userIdFileRention.fileRetention});
            simpleJdbcTemplate.update("update users set quota_group_id = ? where id = ?", new Object[]{quotaGroupId, userIdFileRention.userId});
        }
        List dependentUsers = simpleJdbcTemplate.query("select u1.id, u2.quota_group_id from users u1 join users u2 on u1.user_id_registrator = u2.id where u1.quota_group_id is null", (ParameterizedRowMapper)new IdQuotaGroupIdRowMapper(), new Object[0]);
        for (IdQuotaGroupIdHolder idHolder : dependentUsers) {
            simpleJdbcTemplate.update("update users set quota_group_id = ? where id = ?", new Object[]{idHolder.quotaGroupId, idHolder.userId});
        }
        simpleJdbcTemplate.update("alter table users drop column file_retention", new Object[0]);
        simpleJdbcTemplate.update("create index user_quota_group_fk_i on users (quota_group_id)", new Object[0]);
        simpleJdbcTemplate.queryForList("select CALC_ACCOUNTING_FOR_ALL_QUOTA_GROUPS()", new Object[0]);
    }

    private final class IdFileRententionRowMapper
    implements ParameterizedRowMapper<IdFileRentionHolder> {
        private IdFileRententionRowMapper() {
        }

        public IdFileRentionHolder mapRow(ResultSet rs, int rowNum) throws SQLException {
            long fileRetention = Math.max(rs.getLong("file_retention") / 60L, 1L);
            if (rs.wasNull()) {
                return new IdFileRentionHolder(rs.getLong("id"), null);
            }
            return new IdFileRentionHolder(rs.getLong("id"), fileRetention);
        }
    }

    private final class IdFileRentionHolder {
        final long userId;
        final Long fileRetention;

        IdFileRentionHolder(long userId, Long fileRetention) {
            this.userId = userId;
            this.fileRetention = fileRetention;
        }
    }

    private final class IdQuotaGroupIdHolder {
        final long userId;
        final long quotaGroupId;

        IdQuotaGroupIdHolder(long userId, long quotaGroupId) {
            this.userId = userId;
            this.quotaGroupId = quotaGroupId;
        }
    }

    private final class IdQuotaGroupIdRowMapper
    implements ParameterizedRowMapper<IdQuotaGroupIdHolder> {
        private IdQuotaGroupIdRowMapper() {
        }

        public IdQuotaGroupIdHolder mapRow(ResultSet rs, int rowNum) throws SQLException {
            return new IdQuotaGroupIdHolder(rs.getLong("id"), rs.getLong("quota_group_id"));
        }
    }
}

