/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.filesystem.highwatermark;

import ch.systemsx.cisd.common.filesystem.DirectoryScanningHandlerInterceptor;
import ch.systemsx.cisd.common.filesystem.DirectoryScanningTimerTask;
import ch.systemsx.cisd.common.filesystem.HostAwareFile;
import ch.systemsx.cisd.common.filesystem.IDirectoryScanningHandler;
import ch.systemsx.cisd.common.filesystem.StoreItem;
import ch.systemsx.cisd.common.filesystem.highwatermark.HighwaterMarkWatcher;
import java.io.File;

public final class HighwaterMarkDirectoryScanningHandler
extends DirectoryScanningHandlerInterceptor {
    private final HighwaterMarkWatcher highwaterMarkWatcher;
    private final HostAwareFile[] files;

    public HighwaterMarkDirectoryScanningHandler(IDirectoryScanningHandler directoryScanningHandler, HighwaterMarkWatcher highwaterMarkWatcher, File ... files) {
        this(directoryScanningHandler, highwaterMarkWatcher, HighwaterMarkDirectoryScanningHandler.convertToHostAwareFiles(files));
    }

    public HighwaterMarkDirectoryScanningHandler(IDirectoryScanningHandler directoryScanningHandler, HighwaterMarkWatcher highwaterMarkWatcher, HostAwareFile[] files) {
        super(directoryScanningHandler);
        assert (directoryScanningHandler != null) : "Unspecified IDirectoryScanningHandler";
        assert (highwaterMarkWatcher != null) : "Unspecified HighwaterMarkWatcher";
        assert (files != null) : "Unspecified files";
        this.highwaterMarkWatcher = highwaterMarkWatcher;
        this.files = files;
    }

    private static HostAwareFile[] convertToHostAwareFiles(File ... files) {
        HostAwareFile[] hostAwareFiles = new HostAwareFile[files.length];
        int i = 0;
        while (i < files.length) {
            hostAwareFiles[i] = new HostAwareFile(files[i]);
            ++i;
        }
        return hostAwareFiles;
    }

    private final boolean mayHandle() {
        if (this.files.length < 1) {
            return !this.isBelow();
        }
        HostAwareFile[] hostAwareFileArray = this.files;
        int n = this.files.length;
        int n2 = 0;
        while (n2 < n) {
            HostAwareFile file = hostAwareFileArray[n2];
            if (this.isBelow(file)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private final boolean isBelow() {
        this.highwaterMarkWatcher.run();
        return this.highwaterMarkWatcher.isBelow();
    }

    private final boolean isBelow(HostAwareFile path) {
        this.highwaterMarkWatcher.setPathAndRun(path);
        return this.highwaterMarkWatcher.isBelow();
    }

    @Override
    public IDirectoryScanningHandler.HandleInstruction mayHandle(DirectoryScanningTimerTask.IScannedStore scannedStore, StoreItem storeItem) {
        return !this.mayHandle() ? IDirectoryScanningHandler.HandleInstruction.createError("Not enough disk space on store '%s'.", scannedStore) : super.mayHandle(scannedStore, storeItem);
    }
}

