/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.dbmigration;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.db.ISqlScriptExecutor;
import ch.systemsx.cisd.dbmigration.DatabaseDefinition;
import ch.systemsx.cisd.dbmigration.IDatabaseAdminDAO;
import ch.systemsx.cisd.dbmigration.IMassUploader;
import ch.systemsx.cisd.dbmigration.TableColumnDefinition;
import ch.systemsx.cisd.dbmigration.TableDefinition;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.sql.DataSource;
import org.springframework.jdbc.core.simple.SimpleJdbcDaoSupport;

public abstract class AbstractDatabaseAdminDAO
extends SimpleJdbcDaoSupport
implements IDatabaseAdminDAO {
    protected final ISqlScriptExecutor scriptExecutor;
    protected final IMassUploader massUploader;
    protected final String owner;
    protected final String readOnlyGroupOrNull;
    protected final String readWriteGroupOrNull;
    protected final String databaseName;
    protected final String databaseURL;

    public AbstractDatabaseAdminDAO(DataSource dataSource, ISqlScriptExecutor scriptExecutor, IMassUploader massUploader, String owner, String readOnlyGroupOrNull, String readWriteGroupOrNull, String databaseName, String databaseURL) {
        this.scriptExecutor = scriptExecutor;
        this.massUploader = massUploader;
        this.owner = owner;
        this.readOnlyGroupOrNull = readOnlyGroupOrNull;
        this.readWriteGroupOrNull = readWriteGroupOrNull;
        this.databaseName = databaseName;
        this.databaseURL = databaseURL;
        this.setDataSource(dataSource);
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public String getDatabaseURL() {
        return this.databaseURL;
    }

    @Override
    public DatabaseDefinition getDatabaseDefinition() {
        DatabaseDefinition databaseDefinition = new DatabaseDefinition();
        try {
            Connection connection = this.getDataSource().getConnection();
            Statement statement = connection.createStatement();
            DatabaseMetaData metaData = connection.getMetaData();
            ResultSet rs = metaData.getTables(null, null, null, new String[]{"TABLE"});
            while (rs.next()) {
                databaseDefinition.add(new TableDefinition(rs.getString("TABLE_NAME")));
            }
            this.addColumns(databaseDefinition, metaData);
            this.addConnections(databaseDefinition, metaData);
            this.setLargestPrimaryKeys(databaseDefinition, statement);
            statement.close();
            connection.close();
        }
        catch (SQLException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
        return databaseDefinition;
    }

    private void addColumns(DatabaseDefinition databaseDefinition, DatabaseMetaData metaData) throws SQLException {
        for (TableDefinition tableDefinition : databaseDefinition) {
            String tableName = tableDefinition.getTableName();
            ResultSet rs = metaData.getColumns(null, "%", tableName, "%");
            while (rs.next()) {
                TableColumnDefinition columnDefinition = new TableColumnDefinition(tableDefinition);
                columnDefinition.setColumnName(rs.getString("COLUMN_NAME"));
                columnDefinition.setDataTypeName(rs.getString("TYPE_NAME"));
                tableDefinition.add(columnDefinition);
            }
        }
    }

    private void addConnections(DatabaseDefinition databaseDefinition, DatabaseMetaData metaData) throws SQLException {
        for (TableDefinition tableDefinition : databaseDefinition) {
            String tableName = tableDefinition.getTableName();
            ResultSet rs = metaData.getPrimaryKeys(null, null, tableName);
            while (rs.next()) {
                tableDefinition.defineColumnAsPrimaryKey(rs.getString("COLUMN_NAME"));
            }
            rs = metaData.getExportedKeys(null, null, tableName);
            while (rs.next()) {
                String pkTableName = rs.getString("PKTABLE_NAME");
                String pkColumnName = rs.getString("PKCOLUMN_NAME");
                String fkTableName = rs.getString("FKTABLE_NAME");
                String fkColumnName = rs.getString("FKCOLUMN_NAME");
                databaseDefinition.connect(pkTableName, pkColumnName, fkTableName, fkColumnName);
            }
        }
    }

    private void setLargestPrimaryKeys(DatabaseDefinition databaseDefinition, Statement statement) throws SQLException {
        for (TableDefinition tableDefinition : databaseDefinition) {
            for (TableColumnDefinition columnDefinition : tableDefinition) {
                if (!columnDefinition.isPrimaryKey()) continue;
                String tableName = tableDefinition.getTableName();
                String columnName = columnDefinition.getColumnName();
                String sql = "select max(" + columnName + ") from " + tableName;
                ResultSet rs = statement.executeQuery(sql);
                rs.next();
                columnDefinition.setLargestPrimaryKey(rs.getLong(1));
            }
        }
    }
}

