/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IPluginScriptRunnerFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.IReportingPluginScriptRunner;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.ITableModelCreator;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.JythonBasedPluginUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.JythonBasedProcessingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.PluginScriptRunnerFactory;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.Utils;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.jython.api.IDataSet;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractTableModelReportingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSetProcessingContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.api.ISimpleTableModelBuilderAdaptor;
import java.io.File;
import java.util.List;
import java.util.Properties;
import org.apache.log4j.Logger;

public class JythonBasedReportingPlugin
extends AbstractTableModelReportingPlugin {
    private static final long serialVersionUID = 1L;
    private static final Logger notifyLog = LogFactory.getLogger(LogCategory.NOTIFY, JythonBasedReportingPlugin.class);
    private final IPluginScriptRunnerFactory scriptRunnerFactory;
    transient IHierarchicalContentProvider hierarchicalContentProvider;

    protected static String getScriptPathProperty(Properties properties) {
        return JythonBasedProcessingPlugin.getScriptPathProperty(properties);
    }

    public JythonBasedReportingPlugin(Properties properties, File storeRoot) {
        this(properties, storeRoot, new PluginScriptRunnerFactory(JythonBasedReportingPlugin.getScriptPathProperty(properties)), null);
    }

    protected JythonBasedReportingPlugin(Properties properties, File storeRoot, IPluginScriptRunnerFactory scriptRunnerFactory, IHierarchicalContentProvider contentProvider) {
        super(properties, storeRoot);
        this.scriptRunnerFactory = scriptRunnerFactory;
        this.hierarchicalContentProvider = contentProvider;
    }

    @Override
    public TableModel createReport(List<DatasetDescription> dataSets, DataSetProcessingContext context) {
        return JythonBasedReportingPlugin.createReport(dataSets, context, this.scriptRunnerFactory, this.getHierarchicalContentProvider());
    }

    private IHierarchicalContentProvider getHierarchicalContentProvider() {
        if (this.hierarchicalContentProvider == null) {
            this.hierarchicalContentProvider = ServiceProvider.getHierarchicalContentProvider();
        }
        return this.hierarchicalContentProvider;
    }

    public static TableModel createReport(final List<DatasetDescription> dataSets, final DataSetProcessingContext context, final IPluginScriptRunnerFactory scriptRunnerFactory, final IHierarchicalContentProvider contentProvider) {
        ITableModelCreator generator = new ITableModelCreator(){

            @Override
            public void create(ISimpleTableModelBuilderAdaptor builder) {
                operationLog.info((Object)("Report for the following datasets has been requested: " + dataSets));
                IReportingPluginScriptRunner scriptRunner = scriptRunnerFactory.createReportingPluginRunner(context);
                List<IDataSet> iDataSets = JythonBasedPluginUtils.convert(dataSets, contentProvider);
                try {
                    scriptRunner.describe(iDataSets, builder);
                }
                finally {
                    operationLog.info((Object)"Reporting done");
                    JythonBasedPluginUtils.closeContent(iDataSets);
                    scriptRunner.releaseResources();
                }
            }
        };
        return Utils.generateTableModel(generator, scriptRunnerFactory.getScriptPath(), notifyLog);
    }
}

